/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownThread.class);
    private static final ShutdownThread _thread = new ShutdownThread();
    private boolean _hooked;
    private final List<LifeCycle> _lifeCycles = new CopyOnWriteArrayList<LifeCycle>();

    private ShutdownThread() {
        super("JettyShutdownThread");
    }

    private synchronized void hook() {
        try {
            if (!this._hooked) {
                Runtime.getRuntime().addShutdownHook(this);
            }
            this._hooked = true;
        }
        catch (Exception e) {
            LOG.trace("IGNORED", e);
            LOG.info("shutdown already commenced");
        }
    }

    private synchronized void unhook() {
        try {
            this._hooked = false;
            Runtime.getRuntime().removeShutdownHook(this);
        }
        catch (Exception e) {
            LOG.trace("IGNORED", e);
            LOG.debug("shutdown already commenced");
        }
    }

    public static ShutdownThread getInstance() {
        return _thread;
    }

    public static synchronized void register(LifeCycle ... lifeCycles) {
        ShutdownThread._thread._lifeCycles.addAll(Arrays.asList(lifeCycles));
        if (ShutdownThread._thread._lifeCycles.size() > 0) {
            _thread.hook();
        }
    }

    public static synchronized void register(int index, LifeCycle ... lifeCycles) {
        ShutdownThread._thread._lifeCycles.addAll(index, Arrays.asList(lifeCycles));
        if (ShutdownThread._thread._lifeCycles.size() > 0) {
            _thread.hook();
        }
    }

    public static synchronized void deregister(LifeCycle lifeCycle) {
        ShutdownThread._thread._lifeCycles.remove(lifeCycle);
        if (ShutdownThread._thread._lifeCycles.size() == 0) {
            _thread.unhook();
        }
    }

    public static synchronized boolean isRegistered(LifeCycle lifeCycle) {
        return ShutdownThread._thread._lifeCycles.contains(lifeCycle);
    }

    @Override
    public void run() {
        for (LifeCycle lifeCycle : ShutdownThread._thread._lifeCycles) {
            try {
                if (lifeCycle.isStarted()) {
                    lifeCycle.stop();
                    LOG.debug("Stopped {}", (Object)lifeCycle);
                }
                if (!(lifeCycle instanceof Destroyable)) continue;
                ((Destroyable)((Object)lifeCycle)).destroy();
                LOG.debug("Destroyed {}", (Object)lifeCycle);
            }
            catch (Exception ex) {
                LOG.debug("Unable to stop", ex);
            }
        }
    }
}

