/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServletPathMapping;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
implements RequestDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(Dispatcher.class);
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    private final ContextHandler _contextHandler;
    private final HttpURI _uri;
    private final String _pathInContext;
    private final String _named;

    public Dispatcher(ContextHandler contextHandler, HttpURI uri, String pathInContext) {
        this._contextHandler = contextHandler;
        this._uri = uri.asImmutable();
        this._pathInContext = pathInContext;
        this._named = null;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._uri = null;
        this._pathInContext = null;
        this._named = name;
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request baseRequest = Request.getBaseRequest(request);
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap<String> old_query_params = baseRequest.getQueryParameters();
        try {
            baseRequest.setDispatcherType(DispatcherType.INCLUDE);
            baseRequest.getResponse().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                IncludeAttributes attr = new IncludeAttributes(old_attr, this._uri.getPath(), this._contextHandler.getContextPath(), this._pathInContext, this._uri.getQuery());
                if (attr._query != null) {
                    baseRequest.mergeQueryParameters(baseRequest.getQueryString(), attr._query);
                }
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._pathInContext, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        finally {
            baseRequest.setAttributes(old_attr);
            baseRequest.getResponse().included();
            baseRequest.setQueryParameters(old_query_params);
            baseRequest.resetParameters();
            baseRequest.setDispatcherType(old_type);
        }
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        block14: {
            Request baseRequest = Request.getBaseRequest(request);
            Response baseResponse = baseRequest.getResponse();
            baseResponse.resetForForward();
            if (!(request instanceof HttpServletRequest)) {
                request = new ServletRequestHttpWrapper(request);
            }
            if (!(response instanceof HttpServletResponse)) {
                response = new ServletResponseHttpWrapper(response);
            }
            HttpURI old_uri = baseRequest.getHttpURI();
            String old_context_path = baseRequest.getContextPath();
            String old_servlet_path = baseRequest.getServletPath();
            String old_path_info = baseRequest.getPathInfo();
            ServletPathMapping old_mapping = baseRequest.getServletPathMapping();
            MultiMap<String> old_query_params = baseRequest.getQueryParameters();
            Attributes old_attr = baseRequest.getAttributes();
            DispatcherType old_type = baseRequest.getDispatcherType();
            try {
                baseRequest.setDispatcherType(dispatch);
                if (this._named != null) {
                    this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
                    break block14;
                }
                ForwardAttributes attr = old_attr.getAttribute("javax.servlet.forward.request_uri") != null ? new ForwardAttributes(old_attr, (String)old_attr.getAttribute("javax.servlet.forward.request_uri"), (String)old_attr.getAttribute("javax.servlet.forward.context_path"), (String)old_attr.getAttribute("javax.servlet.forward.path_info"), (ServletPathMapping)old_attr.getAttribute("javax.servlet.forward.mapping"), (String)old_attr.getAttribute("javax.servlet.forward.query_string")) : new ForwardAttributes(old_attr, old_uri.getPath(), old_context_path, baseRequest.getPathInfo(), old_mapping, old_uri.getQuery());
                String query = this._uri.getQuery();
                if (query == null) {
                    query = old_uri.getQuery();
                }
                baseRequest.setHttpURI(HttpURI.build(old_uri, this._uri.getPath(), this._uri.getParam(), query));
                baseRequest.setContextPath(this._contextHandler.getContextPath());
                baseRequest.setServletPathMapping(null);
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(this._pathInContext);
                if (this._uri.getQuery() != null || old_uri.getQuery() != null) {
                    try {
                        baseRequest.mergeQueryParameters(old_uri.getQuery(), this._uri.getQuery());
                    }
                    catch (BadMessageException e) {
                        if (dispatch != DispatcherType.ERROR) {
                            throw e;
                        }
                        LOG.warn("Ignoring Original Bad Request Query String: " + old_uri, e);
                    }
                }
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._pathInContext, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
                if (!baseRequest.getHttpChannelState().isAsync() && !baseResponse.getHttpOutput().isClosed()) {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException e) {
                        response.getWriter().close();
                    }
                }
            }
            finally {
                baseRequest.setHttpURI(old_uri);
                baseRequest.setContextPath(old_context_path);
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
                baseRequest.setQueryParameters(old_query_params);
                baseRequest.resetParameters();
                baseRequest.setAttributes(old_attr);
                baseRequest.setDispatcherType(old_type);
            }
        }
    }

    public String toString() {
        return String.format("Dispatcher@0x%x{%s,%s}", this.hashCode(), this._named, this._uri);
    }

    private class IncludeAttributes
    extends Attributes.Wrapper {
        private final String _requestURI;
        private final String _contextPath;
        private final String _pathInContext;
        private ServletPathMapping _servletPathMapping;
        private final String _query;

        public IncludeAttributes(Attributes attributes, String requestURI, String contextPath, String pathInContext, String query) {
            super(attributes);
            this._requestURI = requestURI;
            this._contextPath = contextPath;
            this._pathInContext = pathInContext;
            this._query = query;
        }

        @Override
        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                switch (key) {
                    case "javax.servlet.include.path_info": {
                        return this._servletPathMapping == null ? this._pathInContext : this._servletPathMapping.getPathInfo();
                    }
                    case "javax.servlet.include.servlet_path": {
                        return this._servletPathMapping == null ? null : this._servletPathMapping.getServletPath();
                    }
                    case "javax.servlet.include.context_path": {
                        return this._contextPath;
                    }
                    case "javax.servlet.include.query_string": {
                        return this._query;
                    }
                    case "javax.servlet.include.request_uri": {
                        return this._requestURI;
                    }
                    case "javax.servlet.include.mapping": {
                        return this._servletPathMapping;
                    }
                }
            }
            return this._attributes.getAttribute(key);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> set = new HashSet<String>();
            for (String name : this._attributes.getAttributeNameSet()) {
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                set.add("javax.servlet.include.path_info");
                set.add("javax.servlet.include.request_uri");
                set.add("javax.servlet.include.servlet_path");
                set.add("javax.servlet.include.context_path");
                set.add("javax.servlet.include.mapping");
                set.add("javax.servlet.include.query_string");
            }
            return set;
        }

        @Override
        public void setAttribute(String key, Object value) {
            if (this._servletPathMapping == null && Dispatcher.this._named == null && "javax.servlet.include.mapping".equals(key)) {
                this._servletPathMapping = (ServletPathMapping)value;
            } else {
                this._attributes.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attributes.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    extends Attributes.Wrapper {
        private final String _requestURI;
        private final String _contextPath;
        private final String _pathInContext;
        private final ServletPathMapping _servletPathMapping;
        private final String _query;

        public ForwardAttributes(Attributes attributes, String requestURI, String contextPath, String pathInContext, ServletPathMapping mapping, String query) {
            super(attributes);
            this._requestURI = requestURI;
            this._contextPath = contextPath;
            this._pathInContext = pathInContext;
            this._servletPathMapping = mapping;
            this._query = query;
        }

        @Override
        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                switch (key) {
                    case "javax.servlet.forward.path_info": {
                        return this._servletPathMapping == null ? this._pathInContext : this._servletPathMapping.getPathInfo();
                    }
                    case "javax.servlet.forward.request_uri": {
                        return this._requestURI;
                    }
                    case "javax.servlet.forward.servlet_path": {
                        return this._servletPathMapping == null ? null : this._servletPathMapping.getServletPath();
                    }
                    case "javax.servlet.forward.context_path": {
                        return this._contextPath;
                    }
                    case "javax.servlet.forward.query_string": {
                        return this._query;
                    }
                    case "javax.servlet.forward.mapping": {
                        return this._servletPathMapping;
                    }
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attributes.getAttribute(key);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> set = new HashSet<String>();
            for (String name : this._attributes.getAttributeNameSet()) {
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX) || name.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                set.add("javax.servlet.forward.path_info");
                set.add("javax.servlet.forward.request_uri");
                set.add("javax.servlet.forward.servlet_path");
                set.add("javax.servlet.forward.context_path");
                set.add("javax.servlet.forward.mapping");
                set.add("javax.servlet.forward.query_string");
            }
            return set;
        }

        @Override
        public void setAttribute(String key, Object value) {
            this._attributes.setAttribute(key, value);
        }

        public String toString() {
            return "FORWARD+" + this._attributes.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

