/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLevel;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.LocationAwareLogger;

public class JettyLogger
implements LocationAwareLogger,
Logger {
    private final JettyLoggerFactory factory;
    private final String name;
    private final String condensedName;
    private final JettyAppender appender;
    private JettyLevel level;
    private boolean hideStacks;

    public JettyLogger(JettyLoggerFactory factory, String name, JettyAppender appender) {
        this(factory, name, appender, JettyLevel.INFO, false);
    }

    public JettyLogger(JettyLoggerFactory factory, String name, JettyAppender appender, JettyLevel level, boolean hideStacks) {
        this.factory = factory;
        this.name = name;
        this.condensedName = JettyLogger.condensePackageString(name);
        this.appender = appender;
        this.level = level;
        this.hideStacks = hideStacks;
    }

    private static String condensePackageString(String classname) {
        if (classname == null || classname.isEmpty()) {
            return "";
        }
        int rawLen = classname.length();
        StringBuilder dense = new StringBuilder(rawLen);
        boolean foundStart = false;
        boolean hasPackage = false;
        int startIdx = -1;
        int endIdx = -1;
        for (int i2 = 0; i2 < rawLen; ++i2) {
            char c = classname.charAt(i2);
            if (!foundStart && (foundStart = Character.isJavaIdentifierStart(c))) {
                if (startIdx >= 0) {
                    dense.append(classname.charAt(startIdx));
                    hasPackage = true;
                }
                startIdx = i2;
            }
            if (!foundStart) continue;
            if (Character.isJavaIdentifierPart(c)) {
                endIdx = i2;
                continue;
            }
            foundStart = false;
        }
        if (startIdx >= 0 && endIdx >= startIdx) {
            if (hasPackage) {
                dense.append('.');
            }
            dense.append(classname, startIdx, endIdx + 1);
        }
        return dense.toString();
    }

    public JettyAppender getAppender() {
        return this.appender;
    }

    String getCondensedName() {
        return this.condensedName;
    }

    public JettyLevel getLevel() {
        return this.level;
    }

    public void setLevel(JettyLevel level) {
        this.level = level;
        this.factory.walkChildrenLoggers(this.getName(), logger -> logger.setLevel(level));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isHideStacks() {
        return this.hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this.hideStacks = hideStacks;
        this.factory.walkChildrenLoggers(this.getName(), logger -> logger.setHideStacks(hideStacks));
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, msg);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arg);
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arg1, arg2);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arguments);
        }
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, msg, throwable);
        }
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level.includes(JettyLevel.DEBUG);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, msg);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arg);
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arg1, arg2);
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arguments);
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, msg, throwable);
        }
    }

    @Override
    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level.includes(JettyLevel.ERROR);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, msg);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arg);
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arg1, arg2);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arguments);
        }
    }

    @Override
    public void info(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, msg, throwable);
        }
    }

    @Override
    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level.includes(JettyLevel.INFO);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, msg);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arg);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arg1, arg2);
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arguments);
        }
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, msg, throwable);
        }
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level.includes(JettyLevel.TRACE);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, msg);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arg);
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arguments);
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arg1, arg2);
        }
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, msg, throwable);
        }
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level.includes(JettyLevel.WARN);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    private void emit(Level level, String msg) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, null, msg, new Object[0]);
    }

    private void emit(Level level, String format, Object arg) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        if (arg instanceof Throwable) {
            this.getAppender().emit(this, level, timestamp, threadName, (Throwable)arg, format, new Object[0]);
        } else {
            this.getAppender().emit(this, level, timestamp, threadName, null, format, arg);
        }
    }

    private void emit(Level level, String format, Object arg1, Object arg2) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        if (arg2 instanceof Throwable) {
            this.getAppender().emit(this, level, timestamp, threadName, (Throwable)arg2, format, arg1);
        } else {
            this.getAppender().emit(this, level, timestamp, threadName, null, format, arg1, arg2);
        }
    }

    private void emit(Level level, String format, Object ... arguments) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, null, format, arguments);
    }

    private void emit(Level level, String msg, Throwable throwable) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, throwable, msg, new Object[0]);
    }

    @Override
    public void log(Marker marker, String fqcn, int levelInt, String message, Object[] argArray, Throwable throwable) {
        if (this.level.toInt() <= levelInt) {
            long timestamp = System.currentTimeMillis();
            String threadName = Thread.currentThread().getName();
            this.getAppender().emit(this, JettyLevel.intToLevel(levelInt).toLevel(), timestamp, threadName, throwable, message, argArray);
        }
    }

    public void log(LoggingEvent event) {
        this.getAppender().emit(this, event.getLevel(), event.getTimeStamp(), event.getThreadName(), event.getThrowable(), event.getMessage(), event.getArgumentArray());
    }

    public String toString() {
        return String.format("%s:%s:LEVEL=%s", JettyLogger.class.getSimpleName(), this.name, this.level.name());
    }
}

