/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import java.util.Objects;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;

class NestedClassSelector
implements DiscoverySelector {
    private final List<Class<?>> enclosingClasses;
    private final Class<?> nestedClass;

    NestedClassSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass) {
        this.enclosingClasses = Preconditions.notEmpty(enclosingClasses, "enclosingClasses must not be null or empty");
        this.nestedClass = Preconditions.notNull(nestedClass, "nestedClass must not be null");
    }

    List<Class<?>> getEnclosingClasses() {
        return this.enclosingClasses;
    }

    Class<?> getNestedClass() {
        return this.nestedClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedClassSelector that = (NestedClassSelector)o;
        return this.enclosingClasses.equals(that.enclosingClasses) && this.nestedClass.equals(that.nestedClass);
    }

    public int hashCode() {
        return Objects.hash(this.enclosingClasses, this.nestedClass);
    }
}

