/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.time.Duration;
import java.util.Set;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class JettyWebSocketServletFactory
implements WebSocketPolicy {
    private WebSocketServletFactory factory;

    JettyWebSocketServletFactory(WebSocketServletFactory factory) {
        this.factory = factory;
    }

    public Set<String> getAvailableExtensionNames() {
        return this.factory.getExtensionRegistry().getAvailableExtensionNames();
    }

    @Override
    public WebSocketBehavior getBehavior() {
        return WebSocketBehavior.SERVER;
    }

    @Override
    public boolean isAutoFragment() {
        return this.factory.isAutoFragment();
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.factory.setAutoFragment(autoFragment);
    }

    @Override
    public long getMaxFrameSize() {
        return this.factory.getMaxFrameSize();
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.factory.setMaxFrameSize(maxFrameSize);
    }

    @Override
    public Duration getIdleTimeout() {
        return this.factory.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.factory.setIdleTimeout(duration);
    }

    @Override
    public int getInputBufferSize() {
        return this.factory.getInputBufferSize();
    }

    @Override
    public void setInputBufferSize(int bufferSize) {
        this.factory.setInputBufferSize(bufferSize);
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.factory.getMaxBinaryMessageSize();
    }

    @Override
    public void setMaxBinaryMessageSize(long bufferSize) {
        this.factory.setMaxBinaryMessageSize(bufferSize);
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.factory.getMaxTextMessageSize();
    }

    @Override
    public void setMaxTextMessageSize(long bufferSize) {
        this.factory.setMaxTextMessageSize(bufferSize);
    }

    @Override
    public int getOutputBufferSize() {
        return this.factory.getOutputBufferSize();
    }

    @Override
    public void setOutputBufferSize(int bufferSize) {
        this.factory.setOutputBufferSize(bufferSize);
    }

    public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
        this.factory.addMapping(pathSpec, (WebSocketCreator)new WrappedCreator(creator));
    }

    public void register(Class<?> endpointClass) {
        this.factory.register(endpointClass);
    }

    public void setCreator(JettyWebSocketCreator creator) {
        this.factory.setCreator(new WrappedCreator(creator));
    }

    public JettyWebSocketCreator getMapping(String pathSpec) {
        WebSocketCreator creator = this.factory.getMapping(this.parsePathSpec(pathSpec));
        if (creator instanceof WrappedCreator) {
            return ((WrappedCreator)creator).getCreator();
        }
        return null;
    }

    public boolean removeMapping(String pathSpec) {
        return this.factory.removeMapping(this.parsePathSpec(pathSpec));
    }

    private PathSpec parsePathSpec(String rawSpec) {
        return this.factory.parsePathSpec(rawSpec);
    }

    private static class WrappedCreator
    implements WebSocketCreator {
        private JettyWebSocketCreator creator;

        private WrappedCreator(JettyWebSocketCreator creator) {
            this.creator = creator;
        }

        public JettyWebSocketCreator getCreator() {
            return this.creator;
        }

        @Override
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return this.creator.createWebSocket(new JettyServerUpgradeRequest(req), new JettyServerUpgradeResponse(resp));
        }
    }
}

