/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import java.io.IOException;
import java.util.function.Function;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.Negotiation;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;

public class WebSocketUpgradeHandler
extends HandlerWrapper {
    static final Logger LOG = Log.getLogger(WebSocketUpgradeHandler.class);
    final Handshaker handshaker = Handshaker.newInstance();
    final PathSpecSet paths = new PathSpecSet();
    final WebSocketNegotiator negotiator;

    public WebSocketUpgradeHandler(Function<Negotiation, FrameHandler> negotiate, String ... pathSpecs) {
        this(WebSocketNegotiator.from(negotiate), pathSpecs);
    }

    public WebSocketUpgradeHandler(WebSocketNegotiator negotiator, String ... pathSpecs) {
        this.negotiator = negotiator;
        this.addPathSpec(pathSpecs);
    }

    public WebSocketNegotiator getWebSocketNegotiator() {
        return this.negotiator;
    }

    public void addPathSpec(String ... pathSpecs) {
        if (pathSpecs != null) {
            for (String spec : pathSpecs) {
                this.paths.add(spec);
            }
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.paths.isEmpty() && !this.paths.test(target)) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        if (this.handshaker.upgradeRequest(this.negotiator, request, response, null)) {
            return;
        }
        if (!baseRequest.isHandled()) {
            super.handle(target, baseRequest, request, response);
        }
    }
}

