/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.ProtocolException;
import org.eclipse.jetty.websocket.core.WebSocketException;

public class Parser {
    private static final Logger LOG = Log.getLogger(Parser.class);
    private final ByteBufferPool bufferPool;
    private final FrameHandler.Configuration configuration;
    private State state = State.START;
    private byte firstByte;
    private int cursor;
    private byte[] mask;
    private int payloadLength;
    private ByteBuffer aggregate;

    public Parser(ByteBufferPool bufferPool) {
        this(bufferPool, new FrameHandler.ConfigurationHolder());
    }

    public Parser(ByteBufferPool bufferPool, FrameHandler.Configuration configuration) {
        this.bufferPool = bufferPool;
        this.configuration = configuration;
    }

    public void reset() {
        this.state = State.START;
        this.firstByte = 0;
        this.mask = null;
        this.cursor = 0;
        this.aggregate = null;
        this.payloadLength = -1;
    }

    /*
     * Exception decompiling
     */
    public ParsedFrame parse(ByteBuffer buffer) throws WebSocketException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkFrameSize(byte opcode, int payloadLength) throws MessageTooLargeException, ProtocolException {
        if (OpCode.isControlFrame(opcode)) {
            if (payloadLength > 125) {
                throw new ProtocolException("Invalid control frame payload length, [" + payloadLength + "] cannot exceed [125]");
            }
        } else {
            long maxFrameSize = this.configuration.getMaxFrameSize();
            if (!this.configuration.isAutoFragment() && maxFrameSize > 0L && (long)payloadLength > maxFrameSize) {
                throw new MessageTooLargeException("Cannot handle payload lengths larger than " + maxFrameSize);
            }
        }
    }

    protected ParsedFrame newFrame(byte firstByte, byte[] mask, ByteBuffer payload, boolean releaseable) {
        boolean fin;
        byte opcode = OpCode.getOpCode(firstByte);
        if (!OpCode.isKnown(opcode)) {
            throw new ProtocolException("Unknown opcode: " + opcode);
        }
        boolean bl = fin = (firstByte & 0x80) != 0;
        if (OpCode.isControlFrame(opcode) && !fin) {
            throw new ProtocolException("Fragmented Control Frame [" + OpCode.name(opcode) + "]");
        }
        return new ParsedFrame(firstByte, mask, payload, releaseable);
    }

    private ParsedFrame autoFragment(ByteBuffer buffer, int fragmentSize) {
        this.payloadLength -= fragmentSize;
        byte[] nextMask = null;
        if (this.mask != null) {
            int shift = fragmentSize % 4;
            nextMask = new byte[]{this.mask[(0 + shift) % 4], this.mask[(1 + shift) % 4], this.mask[(2 + shift) % 4], this.mask[(3 + shift) % 4]};
        }
        ByteBuffer content = buffer.slice();
        content.limit(fragmentSize);
        buffer.position(buffer.position() + fragmentSize);
        ParsedFrame frame = this.newFrame((byte)(this.firstByte & 0x7F), this.mask, content, false);
        this.mask = nextMask;
        this.firstByte = (byte)(this.firstByte & 0x80 | 0);
        this.state = State.FRAGMENT;
        return frame;
    }

    private ParsedFrame parsePayload(ByteBuffer buffer) {
        if (this.payloadLength == 0) {
            return null;
        }
        if (BufferUtil.isEmpty(buffer)) {
            return null;
        }
        int available = buffer.remaining();
        boolean isDataFrame = OpCode.isDataFrame(OpCode.getOpCode(this.firstByte));
        long maxFrameSize = this.configuration.getMaxFrameSize();
        if (maxFrameSize > 0L && isDataFrame && (long)this.payloadLength > maxFrameSize) {
            return this.autoFragment(buffer, (int)Math.min((long)available, maxFrameSize));
        }
        if (this.aggregate == null) {
            if (available < this.payloadLength) {
                if (this.configuration.isAutoFragment() && isDataFrame) {
                    return this.autoFragment(buffer, available);
                }
                this.aggregate = this.bufferPool.acquire(this.payloadLength, false);
                BufferUtil.append(this.aggregate, buffer);
                return null;
            }
            if (available == this.payloadLength) {
                ParsedFrame frame = this.newFrame(this.firstByte, this.mask, buffer.slice(), false);
                buffer.position(buffer.limit());
                this.state = State.START;
                return frame;
            }
            int limit = buffer.limit();
            int end = buffer.position() + this.payloadLength;
            buffer.limit(end);
            ParsedFrame frame = this.newFrame(this.firstByte, this.mask, buffer.slice(), false);
            buffer.position(end);
            buffer.limit(limit);
            this.state = State.START;
            return frame;
        }
        int aggregated = this.aggregate.remaining();
        int expecting = this.payloadLength - aggregated;
        if (available < expecting) {
            BufferUtil.append(this.aggregate, buffer);
            return null;
        }
        if (available == expecting) {
            BufferUtil.append(this.aggregate, buffer);
            this.state = State.START;
            return this.newFrame(this.firstByte, this.mask, this.aggregate, true);
        }
        int limit = buffer.limit();
        buffer.limit(buffer.position() + expecting);
        BufferUtil.append(this.aggregate, buffer);
        buffer.limit(limit);
        this.state = State.START;
        return this.newFrame(this.firstByte, this.mask, this.aggregate, true);
    }

    public String toString() {
        return String.format("Parser@%x[s=%s,c=%d,o=0x%x,m=%s,l=%d]", new Object[]{this.hashCode(), this.state, this.cursor, this.firstByte, this.mask == null ? "-" : TypeUtil.toHexString(this.mask), this.payloadLength});
    }

    public class ParsedFrame
    extends Frame
    implements Closeable,
    CloseStatus.Supplier {
        final CloseStatus closeStatus;
        final boolean releaseable;

        public ParsedFrame(byte firstByte, byte[] mask, ByteBuffer payload, boolean releaseable) {
            super(firstByte, mask, payload);
            this.demask();
            this.releaseable = releaseable;
            this.closeStatus = this.getOpCode() == 8 ? (this.hasPayload() ? new CloseStatus(payload.duplicate()) : CloseStatus.NO_CODE_STATUS) : null;
        }

        @Override
        public void close() {
            if (this.releaseable) {
                Parser.this.bufferPool.release(this.getPayload());
            }
        }

        @Override
        public CloseStatus getCloseStatus() {
            return this.closeStatus;
        }

        public boolean isReleaseable() {
            return this.releaseable;
        }

        @Override
        public String toString() {
            if (this.closeStatus == null) {
                return super.toString();
            }
            return super.toString() + ":" + this.closeStatus;
        }
    }

    private static enum State {
        START,
        PAYLOAD_LEN,
        PAYLOAD_LEN_BYTES,
        MASK,
        MASK_BYTES,
        PAYLOAD,
        FRAGMENT;

    }
}

