/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.internal.FrameEntry;
import org.eclipse.jetty.websocket.core.internal.TransformingFlusher;

public abstract class FragmentingFlusher
extends TransformingFlusher {
    private static final Logger LOG = Log.getLogger(FragmentingFlusher.class);
    private final FrameHandler.Configuration configuration;
    private FrameEntry current;

    public FragmentingFlusher(FrameHandler.Configuration configuration) {
        this.configuration = configuration;
    }

    abstract void forwardFrame(Frame var1, Callback var2, boolean var3);

    @Override
    protected boolean onFrame(Frame frame, Callback callback, boolean batch) {
        long maxFrameSize = this.configuration.getMaxFrameSize();
        if (frame.isControlFrame() || maxFrameSize <= 0L || (long)frame.getPayloadLength() <= maxFrameSize) {
            this.forwardFrame(frame, callback, batch);
            return true;
        }
        this.current = new FrameEntry(frame, callback, batch);
        boolean finished = this.fragment(callback, true);
        if (finished) {
            this.current = null;
        }
        return finished;
    }

    @Override
    protected boolean transform(Callback callback) {
        boolean finished = this.fragment(callback, false);
        if (finished) {
            this.current = null;
        }
        return finished;
    }

    private boolean fragment(Callback callback, boolean first) {
        Frame frame = this.current.frame;
        ByteBuffer payload = frame.getPayload();
        int remaining = payload.remaining();
        long maxFrameSize = this.configuration.getMaxFrameSize();
        int fragmentSize = (int)Math.min((long)remaining, maxFrameSize);
        boolean continuation = frame.getOpCode() == 0 || !first;
        Frame fragment = new Frame(continuation ? (byte)0 : frame.getOpCode());
        boolean finished = maxFrameSize <= 0L || (long)remaining <= maxFrameSize;
        fragment.setFin(frame.isFin() && finished);
        if (finished) {
            fragment.setPayload(frame.getPayload());
            this.forwardFrame(fragment, callback, this.current.batch);
            return true;
        }
        int limit = payload.limit();
        int newLimit = payload.position() + fragmentSize;
        payload.limit(newLimit);
        ByteBuffer payloadFragment = payload.slice();
        payload.limit(limit);
        fragment.setPayload(payloadFragment);
        payload.position(newLimit);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fragmented {}->{}", frame, fragment);
        }
        this.forwardFrame(fragment, callback, this.current.batch);
        return false;
    }
}

