/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.IncomingFrames;
import org.eclipse.jetty.websocket.core.OutgoingFrames;
import org.eclipse.jetty.websocket.core.WebSocketConstants;

public interface FrameHandler
extends IncomingFrames {
    public void onOpen(CoreSession var1, Callback var2);

    @Override
    public void onFrame(Frame var1, Callback var2);

    public void onError(Throwable var1, Callback var2);

    public void onClosed(CloseStatus var1, Callback var2);

    default public boolean isDemanding() {
        return false;
    }

    public static class ConfigurationCustomizer
    extends ConfigurationHolder
    implements Customizer {
        @Override
        public void customize(Configuration configurable) {
            if (this.idleTimeout != null) {
                configurable.setIdleTimeout(this.idleTimeout);
            }
            if (this.writeTimeout != null) {
                configurable.setWriteTimeout(this.idleTimeout);
            }
            if (this.autoFragment != null) {
                configurable.setAutoFragment(this.autoFragment);
            }
            if (this.maxFrameSize != null) {
                configurable.setMaxFrameSize(this.maxFrameSize);
            }
            if (this.inputBufferSize != null) {
                configurable.setInputBufferSize(this.inputBufferSize);
            }
            if (this.outputBufferSize != null) {
                configurable.setOutputBufferSize(this.outputBufferSize);
            }
            if (this.maxBinaryMessageSize != null) {
                configurable.setMaxBinaryMessageSize(this.maxBinaryMessageSize);
            }
            if (this.maxTextMessageSize != null) {
                configurable.setMaxTextMessageSize(this.maxTextMessageSize);
            }
        }

        public static ConfigurationCustomizer from(ConfigurationCustomizer parent, ConfigurationCustomizer child) {
            ConfigurationCustomizer customizer = new ConfigurationCustomizer();
            parent.customize(customizer);
            child.customize(customizer);
            return customizer;
        }
    }

    public static class ConfigurationHolder
    implements Configuration {
        protected Duration idleTimeout;
        protected Duration writeTimeout;
        protected Boolean autoFragment;
        protected Long maxFrameSize;
        protected Integer outputBufferSize;
        protected Integer inputBufferSize;
        protected Long maxBinaryMessageSize;
        protected Long maxTextMessageSize;

        @Override
        public Duration getIdleTimeout() {
            return this.idleTimeout == null ? WebSocketConstants.DEFAULT_IDLE_TIMEOUT : this.idleTimeout;
        }

        @Override
        public Duration getWriteTimeout() {
            return this.writeTimeout == null ? WebSocketConstants.DEFAULT_WRITE_TIMEOUT : this.writeTimeout;
        }

        @Override
        public void setIdleTimeout(Duration timeout) {
            this.idleTimeout = timeout;
        }

        @Override
        public void setWriteTimeout(Duration timeout) {
            this.writeTimeout = timeout;
        }

        @Override
        public boolean isAutoFragment() {
            return this.autoFragment == null ? true : this.autoFragment;
        }

        @Override
        public void setAutoFragment(boolean autoFragment) {
            this.autoFragment = autoFragment;
        }

        @Override
        public long getMaxFrameSize() {
            return this.maxFrameSize == null ? 65536L : this.maxFrameSize;
        }

        @Override
        public void setMaxFrameSize(long maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
        }

        @Override
        public int getOutputBufferSize() {
            return this.outputBufferSize == null ? 4096 : this.outputBufferSize;
        }

        @Override
        public void setOutputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
        }

        @Override
        public int getInputBufferSize() {
            return this.inputBufferSize == null ? 4096 : this.inputBufferSize;
        }

        @Override
        public void setInputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
        }

        @Override
        public long getMaxBinaryMessageSize() {
            return this.maxBinaryMessageSize == null ? 65536L : this.maxBinaryMessageSize;
        }

        @Override
        public void setMaxBinaryMessageSize(long maxBinaryMessageSize) {
            this.maxBinaryMessageSize = maxBinaryMessageSize;
        }

        @Override
        public long getMaxTextMessageSize() {
            return this.maxTextMessageSize == null ? 65536L : this.maxTextMessageSize;
        }

        @Override
        public void setMaxTextMessageSize(long maxTextMessageSize) {
            this.maxTextMessageSize = maxTextMessageSize;
        }
    }

    public static interface Customizer {
        public void customize(Configuration var1);
    }

    public static interface CoreSession
    extends OutgoingFrames,
    Configuration {
        public String getNegotiatedSubProtocol();

        public List<ExtensionConfig> getNegotiatedExtensions();

        public Map<String, List<String>> getParameterMap();

        public String getProtocolVersion();

        public URI getRequestURI();

        public boolean isSecure();

        public Behavior getBehavior();

        public ByteBufferPool getByteBufferPool();

        public SocketAddress getLocalAddress();

        public SocketAddress getRemoteAddress();

        public boolean isOutputOpen();

        public void flush(Callback var1);

        public void close(Callback var1);

        public void close(int var1, String var2, Callback var3);

        public void abort();

        public void demand(long var1);

        public static class Empty
        extends ConfigurationCustomizer
        implements CoreSession {
            @Override
            public String getNegotiatedSubProtocol() {
                return null;
            }

            @Override
            public List<ExtensionConfig> getNegotiatedExtensions() {
                return null;
            }

            @Override
            public Map<String, List<String>> getParameterMap() {
                return null;
            }

            @Override
            public String getProtocolVersion() {
                return null;
            }

            @Override
            public URI getRequestURI() {
                return null;
            }

            @Override
            public boolean isSecure() {
                return false;
            }

            @Override
            public void abort() {
            }

            @Override
            public Behavior getBehavior() {
                return null;
            }

            @Override
            public ByteBufferPool getByteBufferPool() {
                return null;
            }

            @Override
            public SocketAddress getLocalAddress() {
                return null;
            }

            @Override
            public SocketAddress getRemoteAddress() {
                return null;
            }

            @Override
            public boolean isOutputOpen() {
                return false;
            }

            @Override
            public void flush(Callback callback) {
            }

            @Override
            public void close(Callback callback) {
            }

            @Override
            public void close(int statusCode, String reason, Callback callback) {
            }

            @Override
            public void demand(long n) {
            }

            @Override
            public void sendFrame(Frame frame, Callback callback, boolean batch) {
            }
        }
    }

    public static interface Configuration {
        public Duration getIdleTimeout();

        public Duration getWriteTimeout();

        public void setIdleTimeout(Duration var1);

        public void setWriteTimeout(Duration var1);

        public boolean isAutoFragment();

        public void setAutoFragment(boolean var1);

        public long getMaxFrameSize();

        public void setMaxFrameSize(long var1);

        public int getOutputBufferSize();

        public void setOutputBufferSize(int var1);

        public int getInputBufferSize();

        public void setInputBufferSize(int var1);

        public long getMaxBinaryMessageSize();

        public void setMaxBinaryMessageSize(long var1);

        public long getMaxTextMessageSize();

        public void setMaxTextMessageSize(long var1);
    }
}

