/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Extension;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.IncomingFrames;
import org.eclipse.jetty.websocket.core.OutgoingFrames;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.internal.WebSocketCoreSession;

@ManagedObject(value="Abstract Extension")
public abstract class AbstractExtension
implements Extension {
    private final Logger log = Log.getLogger(this.getClass());
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private OutgoingFrames nextOutgoing;
    private IncomingFrames nextIncoming;
    private WebSocketCoreSession coreSession;
    private DeflaterPool deflaterPool;
    private InflaterPool inflaterPool;

    @Override
    public void init(ExtensionConfig config, WebSocketComponents components) {
        this.config = config;
        this.bufferPool = components.getBufferPool();
        this.deflaterPool = components.getDeflaterPool();
        this.inflaterPool = components.getInflaterPool();
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ExtensionConfig getConfig() {
        return this.config;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @ManagedAttribute(name="Next Incoming Frame Handler", readonly=true)
    public IncomingFrames getNextIncoming() {
        return this.nextIncoming;
    }

    @ManagedAttribute(name="Next Outgoing Frame Handler", readonly=true)
    public OutgoingFrames getNextOutgoing() {
        return this.nextOutgoing;
    }

    @Override
    public boolean isRsv1User() {
        return false;
    }

    @Override
    public boolean isRsv2User() {
        return false;
    }

    @Override
    public boolean isRsv3User() {
        return false;
    }

    protected void nextIncomingFrame(Frame frame, Callback callback) {
        this.log.debug("nextIncomingFrame({})", frame);
        this.nextIncoming.onFrame(frame, callback);
    }

    protected void nextOutgoingFrame(Frame frame, Callback callback, boolean batch) {
        this.log.debug("nextOutgoingFrame({})", frame);
        this.nextOutgoing.sendFrame(frame, callback, batch);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames nextIncoming) {
        this.nextIncoming = nextIncoming;
    }

    @Override
    public void setNextOutgoingFrames(OutgoingFrames nextOutgoing) {
        this.nextOutgoing = nextOutgoing;
    }

    @Override
    public void setWebSocketCoreSession(WebSocketCoreSession coreSession) {
        this.coreSession = coreSession;
    }

    protected WebSocketCoreSession getWebSocketCoreSession() {
        return this.coreSession;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.config.getParameterizedName());
    }
}

