/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.common.AbstractMessageSink;
import org.eclipse.jetty.websocket.common.invoke.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.MessageTooLargeException;

public class StringMessageSink
extends AbstractMessageSink {
    private static final Logger LOG = Log.getLogger(StringMessageSink.class);
    private final Session session;
    private Utf8StringBuilder utf;
    private int size = 0;

    public StringMessageSink(Executor executor, MethodHandle methodHandle, Session session) {
        super(executor, methodHandle);
        this.session = session;
        Objects.requireNonNull(methodHandle, "MethodHandle");
        MethodType onMessageType = MethodType.methodType(Void.TYPE, String.class);
        if (methodHandle.type() != onMessageType) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
        this.size = 0;
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                this.size += payload.remaining();
                long maxMessageSize = this.session.getMaxTextMessageSize();
                if (maxMessageSize > 0L && (long)this.size > maxMessageSize) {
                    throw new MessageTooLargeException("Message size [" + this.size + "] exceeds maximum size [" + maxMessageSize + "]");
                }
                if (this.utf == null) {
                    this.utf = new Utf8StringBuilder(1024);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Raw Payload {}", BufferUtil.toDetailString(payload));
                }
                this.utf.append(payload);
            }
            if (frame.isFin()) {
                if (this.utf != null) {
                    this.methodHandle.invoke(this.utf.toString());
                } else {
                    this.methodHandle.invoke("");
                }
                this.size = 0;
                this.utf = null;
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

