/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Subscriber;

public class BytesContent
extends AbstractSinglePublisher<Content.Chunk>
implements ReactiveRequest.Content {
    private final byte[] bytes;
    private final String contentType;

    public BytesContent(byte[] bytes, String contentType) {
        this.bytes = bytes;
        this.contentType = contentType;
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean rewind() {
        return true;
    }

    @Override
    protected void onRequest(Subscriber<? super Content.Chunk> subscriber, long n) {
        this.emitOnNext(subscriber, Content.Chunk.from((ByteBuffer)ByteBuffer.wrap(this.bytes), (boolean)true));
        this.emitOnComplete(subscriber);
    }
}

