/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractBufferingProcessor;

public class StringBufferingProcessor
extends AbstractBufferingProcessor<String> {
    public StringBufferingProcessor(ReactiveResponse response, int maxCapacity) {
        super(response, maxCapacity);
    }

    @Override
    protected String process(List<Content.Chunk> chunks) {
        int length = chunks.stream().mapToInt(Content.Chunk::remaining).sum();
        byte[] bytes = new byte[length];
        int offset = 0;
        for (Content.Chunk chunk : chunks) {
            int l = chunk.remaining();
            chunk.getByteBuffer().get(bytes, offset, l);
            offset += l;
            chunk.release();
        }
        String encoding = Objects.requireNonNullElse(this.getResponse().getEncoding(), StandardCharsets.UTF_8.name());
        return new String(bytes, Charset.forName(encoding));
    }
}

