/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.AbstractEventPublisher;

public class RequestEventPublisher
extends AbstractEventPublisher<ReactiveRequest.Event>
implements Request.Listener {
    private final ReactiveRequest request;

    public RequestEventPublisher(ReactiveRequest request) {
        this.request = request;
    }

    public void onQueued(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.QUEUED, this.request));
    }

    public void onBegin(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.BEGIN, this.request));
    }

    public void onHeaders(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.HEADERS, this.request));
    }

    public void onCommit(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.COMMIT, this.request));
    }

    public void onContent(Request request, ByteBuffer content) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.CONTENT, this.request, content));
    }

    public void onSuccess(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.SUCCESS, this.request));
        this.succeed();
    }

    public void onFailure(Request request, Throwable failure) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.FAILURE, this.request, failure));
        this.fail(failure);
    }
}

