/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.ByteArrayBufferingProcessor;
import org.eclipse.jetty.reactive.client.internal.ByteBufferBufferingProcessor;
import org.eclipse.jetty.reactive.client.internal.DiscardingProcessor;
import org.eclipse.jetty.reactive.client.internal.ResultProcessor;
import org.eclipse.jetty.reactive.client.internal.StringBufferingProcessor;
import org.eclipse.jetty.reactive.client.internal.Transformer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ReactiveResponse {
    private final ReactiveRequest request;
    private final Response response;
    private String mediaType;
    private String encoding;

    public ReactiveResponse(ReactiveRequest request, Response response) {
        this.request = request;
        this.response = response;
    }

    public ReactiveRequest getReactiveRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public HttpFields getHeaders() {
        return this.response.getHeaders();
    }

    public String getMediaType() {
        this.resolveContentType();
        return this.mediaType.isEmpty() ? null : this.mediaType;
    }

    public String getEncoding() {
        this.resolveContentType();
        return this.encoding.isEmpty() ? null : this.encoding;
    }

    private void resolveContentType() {
        if (this.mediaType == null) {
            String contentType = this.getHeaders().get(HttpHeader.CONTENT_TYPE);
            if (contentType != null) {
                String media = contentType;
                String charset = "charset=";
                int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
                if (index > 0) {
                    media = contentType.substring(0, index);
                    String encoding = contentType.substring(index + charset.length());
                    int semicolon = encoding.indexOf(59);
                    if (semicolon > 0) {
                        encoding = encoding.substring(0, semicolon).trim();
                    }
                    this.encoding = encoding;
                } else {
                    this.encoding = "";
                }
                int semicolon = media.indexOf(59);
                if (semicolon > 0) {
                    media = media.substring(0, semicolon).trim();
                }
                this.mediaType = media;
            } else {
                this.mediaType = "";
                this.encoding = "";
            }
        }
    }

    public String toString() {
        return String.format("Reactive[%s]", this.response);
    }

    public static class Event {
        private final Type type;
        private final ReactiveResponse response;
        private final ByteBuffer content;
        private final Throwable failure;

        public Event(Type type, ReactiveResponse response) {
            this(type, response, null, null);
        }

        public Event(Type type, ReactiveResponse response, ByteBuffer content) {
            this(type, response, content, null);
        }

        public Event(Type type, ReactiveResponse response, Throwable failure) {
            this(type, response, null, failure);
        }

        private Event(Type type, ReactiveResponse response, ByteBuffer content, Throwable failure) {
            this.type = type;
            this.response = response;
            this.content = content;
            this.failure = failure;
        }

        public Type getType() {
            return this.type;
        }

        public ReactiveResponse getResponse() {
            return this.response;
        }

        public ByteBuffer getContent() {
            return this.content;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public static enum Type {
            BEGIN,
            HEADERS,
            CONTENT,
            SUCCESS,
            FAILURE,
            COMPLETE;

        }
    }

    public record Result<T>(ReactiveResponse response, T content) {
    }

    public static class Content {
        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<ReactiveResponse>> discard() {
            return (response, content) -> {
                DiscardingProcessor result = new DiscardingProcessor((ReactiveResponse)response);
                content.subscribe((Subscriber)result);
                return result;
            };
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<String>> asString() {
            return Content.asString(0x200000);
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<String>> asString(int maxCapacity) {
            return (response, content) -> {
                StringBufferingProcessor result = new StringBufferingProcessor((ReactiveResponse)response, maxCapacity);
                content.subscribe((Subscriber)result);
                return result;
            };
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<ByteBuffer>> asByteBuffer() {
            return Content.asByteBuffer(0x200000);
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<ByteBuffer>> asByteBuffer(int maxCapacity) {
            return (response, content) -> {
                ByteBufferBufferingProcessor result = new ByteBufferBufferingProcessor((ReactiveResponse)response, maxCapacity);
                content.subscribe((Subscriber)result);
                return result;
            };
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<byte[]>> asByteArray() {
            return Content.asByteArray(0x200000);
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<byte[]>> asByteArray(int maxCapacity) {
            return (response, content) -> {
                ByteArrayBufferingProcessor result = new ByteArrayBufferingProcessor((ReactiveResponse)response, maxCapacity);
                content.subscribe((Subscriber)result);
                return result;
            };
        }

        public static <T> BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<T>>> asDiscardResult() {
            return (response, content) -> {
                ResultProcessor resultProcessor = new ResultProcessor((ReactiveResponse)response);
                Content.discard().apply((ReactiveResponse)response, (Publisher<Content.Chunk>)content).subscribe(resultProcessor);
                Transformer<Result, Result> transformer = new Transformer<Result, Result>(r -> null);
                resultProcessor.subscribe(transformer);
                return transformer;
            };
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<String>>> asStringResult() {
            return Content.asStringResult(0x200000);
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<String>>> asStringResult(int maxCapacity) {
            return (response, content) -> {
                ResultProcessor resultProcessor = new ResultProcessor((ReactiveResponse)response);
                Content.asString(maxCapacity).apply((ReactiveResponse)response, (Publisher<Content.Chunk>)content).subscribe(resultProcessor);
                return resultProcessor;
            };
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<ByteBuffer>>> asByteBufferResult() {
            return Content.asByteBufferResult(0x200000);
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<ByteBuffer>>> asByteBufferResult(int maxCapacity) {
            return (response, content) -> {
                ResultProcessor resultProcessor = new ResultProcessor((ReactiveResponse)response);
                Content.asByteBuffer(maxCapacity).apply((ReactiveResponse)response, (Publisher<Content.Chunk>)content).subscribe(resultProcessor);
                return resultProcessor;
            };
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<byte[]>>> asByteArrayResult() {
            return Content.asByteArrayResult(0x200000);
        }

        public static BiFunction<ReactiveResponse, Publisher<Content.Chunk>, Publisher<Result<byte[]>>> asByteArrayResult(int maxCapacity) {
            return (response, content) -> {
                ResultProcessor resultProcessor = new ResultProcessor((ReactiveResponse)response);
                Content.asByteArray(maxCapacity).apply((ReactiveResponse)response, (Publisher<Content.Chunk>)content).subscribe(resultProcessor);
                return resultProcessor;
            };
        }
    }
}

