/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.thread.AutoLock;
import org.reactivestreams.Subscriber;

public abstract class AbstractEventPublisher<T>
extends AbstractSinglePublisher<T> {
    private long demand;
    private boolean initial;
    private boolean terminated;
    private Throwable failure;

    @Override
    protected void onRequest(Subscriber<? super T> subscriber, long n) {
        boolean notify = false;
        Throwable failure = null;
        try (AutoLock ignored = this.lock();){
            this.demand = MathUtils.cappedAdd((long)this.demand, (long)n);
            boolean isInitial = this.initial;
            this.initial = false;
            if (isInitial && this.terminated) {
                notify = true;
                failure = this.failure;
            }
        }
        if (notify) {
            if (failure == null) {
                subscriber.onComplete();
            } else {
                subscriber.onError(failure);
            }
        }
    }

    protected void emit(T event) {
        Subscriber subscriber = null;
        try (AutoLock ignored = this.lock();){
            if (!this.isCancelled() && this.demand > 0L) {
                --this.demand;
                subscriber = this.subscriber();
            }
        }
        if (subscriber != null) {
            subscriber.onNext(event);
        }
    }

    protected void succeed() {
        Subscriber subscriber;
        try (AutoLock ignored = this.lock();){
            this.terminated = true;
            subscriber = this.subscriber();
        }
        if (subscriber != null) {
            subscriber.onComplete();
        }
    }

    protected void fail(Throwable failure) {
        Subscriber subscriber;
        try (AutoLock ignored = this.lock();){
            this.terminated = true;
            this.failure = failure;
            subscriber = this.subscriber();
        }
        if (subscriber != null) {
            subscriber.onError(failure);
        }
    }
}

