/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.eclipse.jetty.util.thread.AutoLock;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSinglePublisher<T>
implements Publisher<T>,
Subscription {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSinglePublisher.class);
    private final AutoLock lock = new AutoLock();
    private Subscriber<? super T> subscriber;
    private boolean cancelled;

    protected AutoLock lock() {
        return this.lock.lock();
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "invalid 'null' subscriber");
        IllegalStateException failure = null;
        try (AutoLock ignored = this.lock();){
            if (this.subscriber != null) {
                failure = new IllegalStateException("multiple subscribers not supported");
            } else if (this.isCancelled()) {
                failure = new CancellationException();
            } else {
                this.subscriber = subscriber;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} subscription from {}", (Object)this, subscriber);
        }
        subscriber.onSubscribe((Subscription)this);
        if (failure != null) {
            this.onFailure(subscriber, failure);
        }
    }

    protected Subscriber<? super T> subscriber() {
        try (AutoLock ignored = this.lock();){
            Subscriber<? super T> subscriber = this.subscriber;
            return subscriber;
        }
    }

    public void request(long n) {
        Subscriber<T> subscriber;
        IllegalArgumentException failure = null;
        try (AutoLock ignored = this.lock();){
            if (this.isCancelled()) {
                return;
            }
            subscriber = this.subscriber();
            if (n <= 0L) {
                failure = new IllegalArgumentException("reactive stream violation rule 3.9");
            }
        }
        if (failure != null) {
            this.onFailure(subscriber, failure);
        } else {
            this.onRequest(subscriber, n);
        }
    }

    protected abstract void onRequest(Subscriber<? super T> var1, long var2);

    protected void onFailure(Subscriber<? super T> subscriber, Throwable failure) {
        subscriber.onError(failure);
    }

    public void cancel() {
        Subscriber<? super T> subscriber;
        try (AutoLock ignored = this.lock();){
            this.cancelled = true;
            subscriber = this.subscriber;
            this.subscriber = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} cancelled subscription from {}", (Object)this, subscriber);
        }
    }

    protected boolean isCancelled() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this.cancelled;
            return bl;
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

