/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedSinglePublisher<T>
extends AbstractSinglePublisher<T> {
    public static final Terminal COMPLETE = Subscriber::onComplete;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Queue<Object> items = new ArrayDeque<Object>();
    private long demand;
    private boolean stalled = true;

    public void offer(T item) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("offered item {}", item);
        }
        this.process(item);
    }

    public void complete() {
        this.process(COMPLETE);
    }

    public void fail(Throwable failure) {
        this.process(new Failure(failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(long n) {
        boolean proceed = false;
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            this.demand += n;
            if (this.stalled) {
                this.stalled = false;
                proceed = true;
            }
        }
        if (proceed) {
            this.proceed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Object item) {
        boolean proceed = false;
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            this.items.offer(item);
            if (this.stalled) {
                this.stalled = false;
                proceed = true;
            }
        }
        if (proceed) {
            this.proceed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceed() {
        while (true) {
            Object t;
            boolean terminal;
            Object item;
            QueuedSinglePublisher queuedSinglePublisher = this;
            synchronized (queuedSinglePublisher) {
                item = this.items.peek();
                if (item == null) {
                    this.stalled = true;
                    return;
                }
                if (this.isTerminal(item)) {
                    terminal = true;
                } else if (this.demand > 0L) {
                    --this.demand;
                    terminal = false;
                } else {
                    this.stalled = true;
                    return;
                }
                item = this.items.poll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("processing {} item {}", (Object)(terminal ? "last" : "next"), item);
            }
            if (terminal) {
                t = (Terminal)item;
                t.notify(this.subscriber());
                continue;
            }
            t = item;
            this.subscriber().onNext(t);
        }
    }

    private boolean isTerminal(Object item) {
        return item instanceof Terminal;
    }

    private class Failure<F>
    implements Terminal<F> {
        private final Throwable failure;

        private Failure(Throwable failure) {
            this.failure = failure;
        }

        @Override
        public void notify(Subscriber<? super F> subscriber) {
            subscriber.onError(this.failure);
        }
    }

    @FunctionalInterface
    private static interface Terminal<T> {
        public void notify(Subscriber<? super T> var1);
    }
}

