/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Subscriber;

public abstract class AbstractEventPublisher<T>
extends AbstractSinglePublisher<T> {
    private State state = State.EMITTING;
    private Throwable failure;
    private long demand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(long n) {
        boolean complete = false;
        Throwable failure = null;
        AbstractEventPublisher abstractEventPublisher = this;
        synchronized (abstractEventPublisher) {
            this.demand += n;
            switch (this.state) {
                case COMPLETING: {
                    this.state = State.TERMINATED;
                    complete = true;
                    break;
                }
                case FAILING: {
                    this.state = State.TERMINATED;
                    failure = this.failure;
                    break;
                }
            }
        }
        if (complete) {
            this.subscriber().onComplete();
        } else if (failure != null) {
            this.subscriber().onError(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emit(T event) {
        boolean emit = false;
        AbstractEventPublisher abstractEventPublisher = this;
        synchronized (abstractEventPublisher) {
            if (this.demand > 0L) {
                --this.demand;
                emit = true;
            }
        }
        if (emit) {
            this.subscriber().onNext(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void succeed() {
        AbstractEventPublisher abstractEventPublisher = this;
        synchronized (abstractEventPublisher) {
            this.state = State.COMPLETING;
        }
        Subscriber subscriber = this.subscriber();
        if (subscriber != null) {
            boolean complete = false;
            AbstractEventPublisher abstractEventPublisher2 = this;
            synchronized (abstractEventPublisher2) {
                if (this.state == State.COMPLETING) {
                    this.state = State.TERMINATED;
                    complete = true;
                }
            }
            if (complete) {
                subscriber.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fail(Throwable failure) {
        AbstractEventPublisher abstractEventPublisher = this;
        synchronized (abstractEventPublisher) {
            this.state = State.FAILING;
            this.failure = failure;
        }
        Subscriber subscriber = this.subscriber();
        if (subscriber != null) {
            boolean error = false;
            AbstractEventPublisher abstractEventPublisher2 = this;
            synchronized (abstractEventPublisher2) {
                if (this.state == State.FAILING) {
                    this.state = State.TERMINATED;
                    error = true;
                }
            }
            if (error) {
                subscriber.onError(failure);
            }
        }
    }

    private static enum State {
        EMITTING,
        COMPLETING,
        FAILING,
        TERMINATED;

    }
}

