/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractSingleProcessor<I, O>
extends AbstractSinglePublisher<O>
implements Processor<I, O> {
    private Subscription upStream;

    protected Subscriber<? super O> downStream() {
        return this.subscriber();
    }

    @Override
    protected void onFailure(Throwable failure) {
        this.upStream().cancel();
        super.onFailure(failure);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.upStream().cancel();
    }

    @Override
    protected void onRequest(long n) {
        this.upStream().request(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription subscription) {
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            if (this.upStream != null) {
                throw new IllegalStateException("multiple subscriptions not supported");
            }
            this.upStream = subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription upStream() {
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            return this.upStream;
        }
    }

    public void onError(Throwable throwable) {
        this.downStream().onError(throwable);
    }

    public void onComplete() {
        this.downStream().onComplete();
    }
}

