/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.quickstart.PreconfigureDescriptorProcessor;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlAppendable;

public class QuickStartWebApp
extends WebAppContext {
    private static final Logger LOG = Log.getLogger(QuickStartWebApp.class);
    public static final String[] __configurationClasses = new String[]{QuickStartConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName()};
    private boolean _preconfigure = false;
    private boolean _autoPreconfigure = false;
    private boolean _startWebapp = false;
    private PreconfigureDescriptorProcessor _preconfigProcessor;
    public static final String[] __preconfigurationClasses = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName()};

    public QuickStartWebApp() {
        this.setConfigurationClasses(__preconfigurationClasses);
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*\\.jar");
    }

    public boolean isPreconfigure() {
        return this._preconfigure;
    }

    public void setPreconfigure(boolean preconfigure) {
        this._preconfigure = preconfigure;
    }

    public boolean isAutoPreconfigure() {
        return this._autoPreconfigure;
    }

    public void setAutoPreconfigure(boolean autoPrecompile) {
        this._autoPreconfigure = autoPrecompile;
    }

    protected void startWebapp() throws Exception {
        if (this.isPreconfigure()) {
            this.generateQuickstartWebXml(this._preconfigProcessor.getXML());
        }
        if (this._startWebapp) {
            super.startWebapp();
        }
    }

    protected void doStart() throws Exception {
        Resource war = null;
        Resource dir = null;
        Resource base = this.getBaseResource();
        if (base == null) {
            base = Resource.newResource((String)this.getWar());
        }
        if (base.isDirectory()) {
            dir = base;
        } else if (base.toString().toLowerCase().endsWith(".war")) {
            war = base;
            String w = war.toString();
            dir = Resource.newResource((String)w.substring(0, w.length() - 4));
            if (!dir.exists()) {
                LOG.info("Quickstart Extract " + war + " to " + dir, new Object[0]);
                dir.getFile().mkdirs();
                JarResource.newJarResource((Resource)war).copyTo(dir.getFile());
            }
            this.setWar(null);
            this.setBaseResource(dir);
        } else {
            throw new IllegalArgumentException();
        }
        Resource qswebxml = dir.addPath("/WEB-INF/quickstart-web.xml");
        if (this.isPreconfigure()) {
            this._preconfigProcessor = new PreconfigureDescriptorProcessor();
            this.getMetaData().addDescriptorProcessor((DescriptorProcessor)this._preconfigProcessor);
            this._startWebapp = false;
        } else if (qswebxml.exists()) {
            this.setConfigurationClasses(__configurationClasses);
            this._startWebapp = true;
        } else if (this._autoPreconfigure) {
            LOG.info("Quickstart preconfigure: {}(war={},dir={})", new Object[]{this, war, dir});
            this._preconfigProcessor = new PreconfigureDescriptorProcessor();
            this.getMetaData().addDescriptorProcessor((DescriptorProcessor)this._preconfigProcessor);
            this.setPreconfigure(true);
            this._startWebapp = true;
        } else {
            this._startWebapp = true;
        }
        super.doStart();
    }

    /*
     * WARNING - void declaration
     */
    public void generateQuickstartWebXml(String extraXML) throws IOException {
        LifeCycleCallbackCollection lifecycles;
        ServletContextHandler.JspConfig jspConfig;
        MimeTypes mimeTypes;
        Map errorPages;
        Map localeEncodings;
        SecurityHandler security;
        ServletHandler servlets;
        this.getMetaData().getOrigins();
        if (this.getBaseResource() == null) {
            throw new IllegalArgumentException("No base resource for " + (Object)((Object)this));
        }
        File webxml = new File(this.getWebInf().getFile(), "quickstart-web.xml");
        LOG.info("Quickstart generate {}", new Object[]{webxml});
        XmlAppendable out = new XmlAppendable((OutputStream)new FileOutputStream(webxml), "UTF-8");
        MetaData md = this.getMetaData();
        HashMap<String, String> webappAttr = new HashMap<String, String>();
        webappAttr.put("xmlns", "http://xmlns.jcp.org/xml/ns/javaee");
        webappAttr.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webappAttr.put("xsi:schemaLocation", "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd");
        webappAttr.put("metadata-complete", "true");
        webappAttr.put("version", "3.1");
        out.open("web-app", webappAttr);
        if (this.getDisplayName() != null) {
            out.tag("display-name", this.getDisplayName());
        }
        String resourceBase = this.getBaseResource().getFile().getCanonicalFile().getAbsoluteFile().toURI().toString();
        this.addContextParamFromAttribute(out, "javax.servlet.context.orderedLibs");
        this.addContextParamFromAttribute(out, "org.eclipse.jetty.containerInitializers");
        this.addContextParamFromAttribute(out, "org.eclipse.jetty.tlds", resourceBase);
        this.addContextParamFromAttribute(out, "org.eclipse.jetty.resources", resourceBase);
        for (String p : this.getInitParams().keySet()) {
            out.open("context-param", QuickStartWebApp.origin(md, "context-param." + p)).tag("param-name", p).tag("param-value", this.getInitParameter(p)).close();
        }
        if (this.getEventListeners() != null) {
            for (EventListener e : this.getEventListeners()) {
                out.open("listener", QuickStartWebApp.origin(md, e.getClass().getCanonicalName() + ".listener")).tag("listener-class", e.getClass().getCanonicalName()).close();
            }
        }
        if ((servlets = this.getServletHandler()).getFilters() != null) {
            for (FilterHolder filterHolder : servlets.getFilters()) {
                QuickStartWebApp.outholder(out, md, "filter", filterHolder);
            }
        }
        if (servlets.getFilterMappings() != null) {
            for (FilterMapping filterMapping : servlets.getFilterMappings()) {
                out.open("filter-mapping");
                out.tag("filter-name", filterMapping.getFilterName());
                if (filterMapping.getPathSpecs() != null) {
                    for (String s : filterMapping.getPathSpecs()) {
                        out.tag("url-pattern", s);
                    }
                }
                if (filterMapping.getServletNames() != null) {
                    for (String n : filterMapping.getServletNames()) {
                        out.tag("servlet-name", n);
                    }
                }
                if (!filterMapping.isDefaultDispatches()) {
                    if (filterMapping.appliesTo(DispatcherType.REQUEST)) {
                        out.tag("dispatcher", "REQUEST");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ASYNC)) {
                        out.tag("dispatcher", "ASYNC");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ERROR)) {
                        out.tag("dispatcher", "ERROR");
                    }
                    if (filterMapping.appliesTo(DispatcherType.FORWARD)) {
                        out.tag("dispatcher", "FORWARD");
                    }
                    if (filterMapping.appliesTo(DispatcherType.INCLUDE)) {
                        out.tag("dispatcher", "INCLUDE");
                    }
                }
                out.close();
            }
        }
        if (servlets.getServlets() != null) {
            for (ServletHolder servletHolder : servlets.getServlets()) {
                QuickStartWebApp.outholder(out, md, "servlet", servletHolder);
            }
        }
        if (servlets.getServletMappings() != null) {
            for (ServletMapping servletMapping : servlets.getServletMappings()) {
                out.open("servlet-mapping", QuickStartWebApp.origin(md, servletMapping.getServletName() + ".servlet.mappings"));
                out.tag("servlet-name", servletMapping.getServletName());
                if (servletMapping.getPathSpecs() != null) {
                    for (String s : servletMapping.getPathSpecs()) {
                        out.tag("url-pattern", s);
                    }
                }
                out.close();
            }
        }
        if ((security = this.getSecurityHandler()) != null && (security.getRealmName() != null || security.getAuthMethod() != null)) {
            out.open("login-config");
            if (security.getAuthMethod() != null) {
                out.tag("auth-method", QuickStartWebApp.origin(md, "auth-method"), security.getAuthMethod());
            }
            if (security.getRealmName() != null) {
                out.tag("realm-name", QuickStartWebApp.origin(md, "realm-name"), security.getRealmName());
            }
            if ("FORM".equalsIgnoreCase(security.getAuthMethod())) {
                out.open("form-login-config");
                out.tag("form-login-page", QuickStartWebApp.origin(md, "form-login-page"), security.getInitParameter("org.eclipse.jetty.security.form_login_page"));
                out.tag("form-error-page", QuickStartWebApp.origin(md, "form-error-page"), security.getInitParameter("org.eclipse.jetty.security.form_error_page"));
                out.close();
            }
            out.close();
        }
        if (security instanceof ConstraintAware) {
            ConstraintAware ca = (ConstraintAware)security;
            for (String string : ca.getRoles()) {
                out.open("security-role").tag("role-name", string).close();
            }
            for (ConstraintMapping constraintMapping : ca.getConstraintMappings()) {
                out.open("security-constraint");
                if (constraintMapping.getConstraint().getAuthenticate()) {
                    out.open("auth-constraint");
                    if (constraintMapping.getConstraint().getRoles() != null) {
                        for (String r : constraintMapping.getConstraint().getRoles()) {
                            out.tag("role-name", r);
                        }
                    }
                    out.close();
                }
                switch (constraintMapping.getConstraint().getDataConstraint()) {
                    case 0: {
                        out.open("user-data-constraint").tag("transport-guarantee", "NONE").close();
                        break;
                    }
                    case 1: {
                        out.open("user-data-constraint").tag("transport-guarantee", "INTEGRAL").close();
                        break;
                    }
                    case 2: {
                        out.open("user-data-constraint").tag("transport-guarantee", "CONFIDENTIAL").close();
                        break;
                    }
                }
                out.open("web-resource-collection");
                if (constraintMapping.getConstraint().getName() != null) {
                    out.tag("web-resource-name", constraintMapping.getConstraint().getName());
                }
                if (constraintMapping.getPathSpec() != null) {
                    out.tag("url-pattern", QuickStartWebApp.origin(md, "constraint.url." + constraintMapping.getPathSpec()), constraintMapping.getPathSpec());
                }
                if (constraintMapping.getMethod() != null) {
                    out.tag("http-method", constraintMapping.getMethod());
                }
                if (constraintMapping.getMethodOmissions() != null) {
                    for (String o : constraintMapping.getMethodOmissions()) {
                        out.tag("http-method-omission", o);
                    }
                }
                out.close();
                out.close();
            }
        }
        if (this.getWelcomeFiles() != null) {
            void var11_41;
            out.open("welcome-file-list");
            String[] arr$ = this.getWelcomeFiles();
            int len$ = arr$.length;
            boolean bl = false;
            while (var11_41 < len$) {
                String welcomeFile = arr$[var11_41];
                out.tag("welcome-file", welcomeFile);
                ++var11_41;
            }
            out.close();
        }
        if ((localeEncodings = this.getLocaleEncodings()) != null && !localeEncodings.isEmpty()) {
            out.open("locale-encoding-mapping-list");
            for (Map.Entry entry : localeEncodings.entrySet()) {
                out.open("locale-encoding-mapping", QuickStartWebApp.origin(md, "locale-encoding." + (String)entry.getKey()));
                out.tag("locale", (String)entry.getKey());
                out.tag("encoding", (String)entry.getValue());
                out.close();
            }
            out.close();
        }
        if (this.getSessionHandler().getSessionManager() != null) {
            SessionCookieConfig cookieConfig;
            out.open("session-config");
            int maxInactiveSec = this.getSessionHandler().getSessionManager().getMaxInactiveInterval();
            out.tag("session-timeout", maxInactiveSec == 0 ? "0" : Integer.toString(maxInactiveSec / 60));
            Set set = this.getSessionHandler().getSessionManager().getEffectiveSessionTrackingModes();
            if (set != null) {
                for (SessionTrackingMode mode : set) {
                    out.tag("tracking-mode", mode.toString());
                }
            }
            if ((cookieConfig = this.getSessionHandler().getSessionManager().getSessionCookieConfig()) != null) {
                out.open("cookie-config");
                if (cookieConfig.getName() != null) {
                    out.tag("name", QuickStartWebApp.origin(md, "cookie-config.name"), cookieConfig.getName());
                }
                if (cookieConfig.getDomain() != null) {
                    out.tag("domain", QuickStartWebApp.origin(md, "cookie-config.domain"), cookieConfig.getDomain());
                }
                if (cookieConfig.getPath() != null) {
                    out.tag("path", QuickStartWebApp.origin(md, "cookie-config.path"), cookieConfig.getPath());
                }
                if (cookieConfig.getComment() != null) {
                    out.tag("comment", QuickStartWebApp.origin(md, "cookie-config.comment"), cookieConfig.getComment());
                }
                out.tag("http-only", QuickStartWebApp.origin(md, "cookie-config.http-only"), Boolean.toString(cookieConfig.isHttpOnly()));
                out.tag("secure", QuickStartWebApp.origin(md, "cookie-config.secure"), Boolean.toString(cookieConfig.isSecure()));
                out.tag("max-age", QuickStartWebApp.origin(md, "cookie-config.max-age"), Integer.toString(cookieConfig.getMaxAge()));
                out.close();
            }
            out.close();
        }
        if ((errorPages = ((ErrorPageErrorHandler)this.getErrorHandler()).getErrorPages()) != null) {
            for (Map.Entry entry : errorPages.entrySet()) {
                out.open("error-page", QuickStartWebApp.origin(md, "error." + (String)entry.getKey()));
                if (!"org.eclipse.jetty.server.error_page.global".equals(entry.getKey())) {
                    if (((String)entry.getKey()).matches("\\d{3}")) {
                        out.tag("error-code", (String)entry.getKey());
                    } else {
                        out.tag("exception-type", (String)entry.getKey());
                    }
                }
                out.tag("location", (String)entry.getValue());
                out.close();
            }
        }
        if ((mimeTypes = this.getMimeTypes()) != null) {
            for (Map.Entry entry : mimeTypes.getMimeMap().entrySet()) {
                out.open("mime-mapping");
                out.tag("extension", QuickStartWebApp.origin(md, "extension." + (String)entry.getKey()), (String)entry.getKey());
                out.tag("mime-type", (String)entry.getValue());
                out.close();
            }
        }
        if ((jspConfig = (ServletContextHandler.JspConfig)this.getServletContext().getJspConfigDescriptor()) != null) {
            Collection jspPropertyGroups;
            out.open("jsp-config");
            Collection tlds = jspConfig.getTaglibs();
            if (tlds != null && !tlds.isEmpty()) {
                for (TaglibDescriptor tld : tlds) {
                    out.open("taglib");
                    out.tag("taglib-uri", tld.getTaglibURI());
                    out.tag("taglib-location", tld.getTaglibLocation());
                    out.close();
                }
            }
            if ((jspPropertyGroups = jspConfig.getJspPropertyGroups()) != null && !jspPropertyGroups.isEmpty()) {
                for (JspPropertyGroupDescriptor jspPropertyGroup : jspPropertyGroups) {
                    out.open("jsp-property-group");
                    Collection strings = jspPropertyGroup.getUrlPatterns();
                    if (strings != null && !strings.isEmpty()) {
                        for (String urlPattern : strings) {
                            out.tag("url-pattern", urlPattern);
                        }
                    }
                    if (jspPropertyGroup.getElIgnored() != null) {
                        out.tag("el-ignored", jspPropertyGroup.getElIgnored());
                    }
                    if (jspPropertyGroup.getPageEncoding() != null) {
                        out.tag("page-encoding", jspPropertyGroup.getPageEncoding());
                    }
                    if (jspPropertyGroup.getScriptingInvalid() != null) {
                        out.tag("scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                    }
                    if (jspPropertyGroup.getIsXml() != null) {
                        out.tag("is-xml", jspPropertyGroup.getIsXml());
                    }
                    if (jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral() != null) {
                        out.tag("deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral());
                    }
                    if (jspPropertyGroup.getTrimDirectiveWhitespaces() != null) {
                        out.tag("trim-directive-whitespaces", jspPropertyGroup.getTrimDirectiveWhitespaces());
                    }
                    if (jspPropertyGroup.getDefaultContentType() != null) {
                        out.tag("default-content-type", jspPropertyGroup.getDefaultContentType());
                    }
                    if (jspPropertyGroup.getBuffer() != null) {
                        out.tag("buffer", jspPropertyGroup.getBuffer());
                    }
                    if (jspPropertyGroup.getErrorOnUndeclaredNamespace() != null) {
                        out.tag("error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                    }
                    if ((strings = jspPropertyGroup.getIncludePreludes()) != null && !strings.isEmpty()) {
                        for (String prelude : strings) {
                            out.tag("include-prelude", prelude);
                        }
                    }
                    if ((strings = jspPropertyGroup.getIncludeCodas()) != null && !strings.isEmpty()) {
                        for (String coda : strings) {
                            out.tag("include-coda", coda);
                        }
                    }
                    out.close();
                }
            }
            out.close();
        }
        if ((lifecycles = (LifeCycleCallbackCollection)this.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            Collection tmp = lifecycles.getPostConstructCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.open("post-construct");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.close();
            }
            tmp = lifecycles.getPreDestroyCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.open("pre-destroy");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.close();
            }
        }
        out.literal(extraXML);
        out.close();
    }

    private void addContextParamFromAttribute(XmlAppendable out, String attribute) throws IOException {
        this.addContextParamFromAttribute(out, attribute, null);
    }

    private void addContextParamFromAttribute(XmlAppendable out, String attribute, String resourceBase) throws IOException {
        Object o = this.getAttribute(attribute);
        if (o == null) {
            return;
        }
        List<Object> c = o instanceof Collection ? (List<Object>)o : Collections.singletonList(o);
        StringBuilder v = new StringBuilder();
        for (Object e : c) {
            if (e == null) continue;
            if (v.length() > 0) {
                v.append(",\n    ");
            } else {
                v.append("\n    ");
            }
            if (resourceBase == null) {
                QuotedStringTokenizer.quote((Appendable)v, (String)e.toString());
                continue;
            }
            QuotedStringTokenizer.quote((Appendable)v, (String)e.toString().replace(resourceBase, "${WAR}/"));
        }
        out.open("context-param").tag("param-name", attribute).tagCDATA("param-value", v.toString()).close();
    }

    private static void outholder(XmlAppendable out, MetaData md, String tag, Holder<?> holder) throws IOException {
        out.open(tag, Collections.singletonMap("source", holder.getSource().toString()));
        String n = holder.getName();
        out.tag(tag + "-name", n);
        String ot = n + "." + tag + ".";
        out.tag(tag + "-class", QuickStartWebApp.origin(md, ot + tag + "-class"), holder.getClassName());
        for (String p : holder.getInitParameters().keySet()) {
            if ("scratchdir".equalsIgnoreCase(p)) continue;
            out.open("init-param", QuickStartWebApp.origin(md, ot + "init-param." + p)).tag("param-name", p).tag("param-value", holder.getInitParameter(p)).close();
        }
        if (holder instanceof ServletHolder) {
            MultipartConfigElement multipartConfig;
            Map roles;
            ServletHolder s = (ServletHolder)holder;
            if (s.getForcedPath() != null) {
                out.tag("jsp-file", s.getForcedPath());
            }
            if (s.getInitOrder() != 0) {
                out.tag("load-on-startup", Integer.toString(s.getInitOrder()));
            }
            if (s.getRunAsRole() != null) {
                out.open("run-as", QuickStartWebApp.origin(md, ot + "run-as")).tag("role-name", s.getRunAsRole()).close();
            }
            if ((roles = s.getRoleRefMap()) != null) {
                for (Map.Entry e : roles.entrySet()) {
                    out.open("security-role-ref", QuickStartWebApp.origin(md, ot + "role-name." + (String)e.getKey())).tag("role-name", (String)e.getKey()).tag("role-link", (String)e.getValue()).close();
                }
            }
            if (!s.isEnabled()) {
                out.tag("enabled", QuickStartWebApp.origin(md, ot + "enabled"), "false");
            }
            if ((multipartConfig = ((ServletHolder.Registration)s.getRegistration()).getMultipartConfig()) != null) {
                out.open("multipart-config", QuickStartWebApp.origin(md, s.getName() + ".servlet.multipart-config"));
                if (multipartConfig.getLocation() != null) {
                    out.tag("location", multipartConfig.getLocation());
                }
                out.tag("max-file-size", Long.toString(multipartConfig.getMaxFileSize()));
                out.tag("max-request-size", Long.toString(multipartConfig.getMaxRequestSize()));
                out.tag("file-size-threshold", Long.toString(multipartConfig.getFileSizeThreshold()));
                out.close();
            }
        }
        out.tag("async-supported", QuickStartWebApp.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        out.close();
    }

    public static Map<String, String> origin(MetaData md, String name) {
        if (!LOG.isDebugEnabled()) {
            return Collections.emptyMap();
        }
        if (name == null) {
            return Collections.emptyMap();
        }
        MetaData.OriginInfo origin = md.getOriginInfo(name);
        if (origin == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("origin", origin.toString());
    }
}

