/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.File;
import java.io.FileInputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.loader.DefaultPolicyLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPolicy
extends Policy {
    private Set<String> _policies;
    private Map<ProtectionDomain, PolicyBlock> pdMapping = Collections.synchronizedMap(new HashMap());
    private PolicyContext _context = new PolicyContext();

    public JettyPolicy(Set<String> policies, Map<String, String> properties) {
        this._policies = policies;
        this._context.setProperties(properties);
        this.refresh();
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        for (ProtectionDomain pd : this.pdMapping.keySet()) {
            Enumeration<Permission> e;
            if (pd.getCodeSource() != null && (!pd.getCodeSource().implies(domain.getCodeSource()) || pd.getPrincipals() != null) && !JettyPolicy.validate(pd.getPrincipals(), domain.getPrincipals())) continue;
            if (this.pdMapping.get(pd) != null) {
                e = this.pdMapping.get(pd).getPermissions().elements();
                while (e.hasMoreElements()) {
                    ((PermissionCollection)perms).add(e.nextElement());
                }
            }
            if (pd.getPermissions() == null) continue;
            e = pd.getPermissions().elements();
            while (e.hasMoreElements()) {
                ((PermissionCollection)perms).add(e.nextElement());
            }
        }
        return perms;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        for (ProtectionDomain pd : this.pdMapping.keySet()) {
            Enumeration<Permission> e;
            if (pd.getCodeSource() != null && !pd.getCodeSource().implies(codesource)) continue;
            if (this.pdMapping.get(pd) != null) {
                e = this.pdMapping.get(pd).getPermissions().elements();
                while (e.hasMoreElements()) {
                    ((PermissionCollection)perms).add(e.nextElement());
                }
            }
            if (pd.getPermissions() == null) continue;
            e = pd.getPermissions().elements();
            while (e.hasMoreElements()) {
                ((PermissionCollection)perms).add(e.nextElement());
            }
        }
        return perms;
    }

    private static boolean validate(Principal[] permCerts, Principal[] classCerts) {
        if (classCerts == null) {
            return false;
        }
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!((Object)permCerts[i]).equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void refresh() {
        try {
            this.pdMapping.clear();
            Iterator<String> i = this._policies.iterator();
            while (i.hasNext()) {
                File policyFile = new File(i.next());
                this.pdMapping.putAll(DefaultPolicyLoader.load(new FileInputStream(policyFile), this._context));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

