/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plugins.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepositoryParser {
    private static final List<String> EXCLUDES = Arrays.asList("..");

    public static List<String> parseLinksInDirectoryListing(String listing) {
        ArrayList<String> modules = new ArrayList<String>();
        List<String> lines = Arrays.asList(listing.split("\n"));
        for (String line : lines) {
            Pattern p = Pattern.compile(".*?<a href=\"[^>]+>(?=([^</]+)/).*");
            Matcher m = p.matcher(line);
            if (!m.matches() || EXCLUDES.contains(m.group(1))) continue;
            modules.add(m.group(1));
        }
        return modules;
    }

    public static boolean isModuleAPlugin(String listing) {
        List<String> lines = Arrays.asList(listing.split("\n"));
        for (String line : lines) {
            Pattern p = Pattern.compile("-plugin\\.jar");
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }
}

