/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.osgi.util.EventSender;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.osgi.framework.Bundle;

public class OSGiDeploymentListener
implements Deployer.Listener {
    public void onDeploying(ContextHandler contextHandler) {
        Bundle bundle = (Bundle)contextHandler.getAttribute("org.eclipse.jetty.osgi.bundle");
        if (bundle == null) {
            EventSender.getInstance().send("org/osgi/service/web/DEPLOYING", bundle, contextHandler.getContextPath());
        }
    }

    public void onDeployed(ContextHandler contextHandler) {
        Bundle bundle = (Bundle)contextHandler.getAttribute("org.eclipse.jetty.osgi.bundle");
        if (bundle == null) {
            Util.registerAsOSGiService(contextHandler);
            EventSender.getInstance().send("org/osgi/service/web/DEPLOYED", bundle, contextHandler.getContextPath());
        }
    }

    public void onUndeploying(ContextHandler contextHandler) {
        Bundle bundle = (Bundle)contextHandler.getAttribute("org.eclipse.jetty.osgi.bundle");
        if (bundle == null) {
            EventSender.getInstance().send("org/osgi/service/web/UNDEPLOYING", bundle, contextHandler.getContextPath());
        }
    }

    public void onUndeployed(ContextHandler contextHandler) {
        Bundle bundle = (Bundle)contextHandler.getAttribute("org.eclipse.jetty.osgi.bundle");
        if (bundle == null) {
            EventSender.getInstance().send("org/osgi/service/web/UNDEPLOYED", bundle, contextHandler.getContextPath());
            Util.deregisterAsOSGiService(contextHandler);
        }
    }

    public void onFailure(ContextHandler contextHandler, Throwable cause) {
        Bundle bundle = (Bundle)contextHandler.getAttribute("org.eclipse.jetty.osgi.bundle");
        if (bundle == null) {
            EventSender.getInstance().send("org/osgi/service/web/FAILED", bundle, contextHandler.getContextPath());
        }
    }
}

