/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdConfiguration
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdConfiguration.class);
    private static final String CONFIG_PATH = "/.well-known/openid-configuration";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String TOKEN_ENDPOINT = "token_endpoint";
    private static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String ISSUER = "issuer";
    private final HttpClient httpClient;
    private final String issuer;
    private final String clientId;
    private final String clientSecret;
    private final List<String> scopes = new ArrayList<String>();
    private final String authenticationMethod;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String endSessionEndpoint;
    private boolean authenticateNewUsers;
    private boolean logoutWhenIdTokenIsExpired;

    @Deprecated(since="12.1.0", forRemoval=true)
    public OpenIdConfiguration(String provider, String clientId, String clientSecret) {
        this(provider, null, null, clientId, clientSecret, null);
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public OpenIdConfiguration(String issuer, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret, HttpClient httpClient) {
        this(issuer, authorizationEndpoint, tokenEndpoint, clientId, clientSecret, "client_secret_post", httpClient);
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public OpenIdConfiguration(@Name(value="issuer") String issuer, @Name(value="authorizationEndpoint") String authorizationEndpoint, @Name(value="tokenEndpoint") String tokenEndpoint, @Name(value="clientId") String clientId, @Name(value="clientSecret") String clientSecret, @Name(value="authenticationMethod") String authenticationMethod, @Name(value="httpClient") HttpClient httpClient) {
        this(issuer, authorizationEndpoint, tokenEndpoint, null, clientId, clientSecret, authenticationMethod, httpClient);
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public OpenIdConfiguration(@Name(value="issuer") String issuer, @Name(value="authorizationEndpoint") String authorizationEndpoint, @Name(value="tokenEndpoint") String tokenEndpoint, @Name(value="endSessionEndpoint") String endSessionEndpoint, @Name(value="clientId") String clientId, @Name(value="clientSecret") String clientSecret, @Name(value="authenticationMethod") String authenticationMethod, @Name(value="httpClient") HttpClient httpClient) {
        this(issuer, clientId, clientSecret, authorizationEndpoint, tokenEndpoint, endSessionEndpoint, authenticationMethod, httpClient, false, false, Collections.emptyList());
    }

    private OpenIdConfiguration(String issuer, String clientId, String clientSecret, String authorizationEndpoint, String tokenEndpoint, String endSessionEndpoint, String authenticationMethod, HttpClient httpClient, boolean authenticateNewUsers, boolean logoutWhenIdTokenIsExpired, List<String> scopes) {
        this.issuer = issuer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authorizationEndpoint = authorizationEndpoint;
        this.endSessionEndpoint = endSessionEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.httpClient = httpClient != null ? httpClient : OpenIdConfiguration.newHttpClient();
        this.authenticationMethod = authenticationMethod == null ? "client_secret_post" : authenticationMethod;
        this.authenticateNewUsers = authenticateNewUsers;
        this.logoutWhenIdTokenIsExpired = logoutWhenIdTokenIsExpired;
        this.scopes.addAll(scopes);
        if (this.issuer == null) {
            throw new IllegalArgumentException("Issuer was not configured");
        }
        this.installBean(this.httpClient);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.authorizationEndpoint == null || this.tokenEndpoint == null) {
            Map<String, Object> discoveryDocument = this.fetchOpenIdConnectMetadata();
            this.processMetadata(discoveryDocument);
        }
    }

    protected void processMetadata(Map<String, Object> discoveryDocument) {
        this.authorizationEndpoint = (String)discoveryDocument.get(AUTHORIZATION_ENDPOINT);
        if (this.authorizationEndpoint == null) {
            throw new IllegalStateException(AUTHORIZATION_ENDPOINT);
        }
        this.tokenEndpoint = (String)discoveryDocument.get(TOKEN_ENDPOINT);
        if (this.tokenEndpoint == null) {
            throw new IllegalStateException(TOKEN_ENDPOINT);
        }
        if (this.endSessionEndpoint == null) {
            this.endSessionEndpoint = (String)discoveryDocument.get(END_SESSION_ENDPOINT);
        }
        if (!Objects.equals(discoveryDocument.get(ISSUER), this.issuer)) {
            LOG.warn("The issuer in the metadata is not correct.");
        }
    }

    protected Map<String, Object> fetchOpenIdConnectMetadata() {
        String provider = this.issuer;
        if (provider.endsWith("/")) {
            provider = provider.substring(0, provider.length() - 1);
        }
        try {
            String responseBody = this.httpClient.GET(provider + CONFIG_PATH).getContentAsString();
            Object parsedResult = new JSON().fromJSON((CharSequence)responseBody);
            if (parsedResult instanceof Map) {
                Map rawResult = (Map)parsedResult;
                Map<String, Object> result = rawResult.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(it -> it.getKey().toString(), Map.Entry::getValue));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("discovery document {}", result);
                }
                return result;
            }
            LOG.warn("OpenID provider did not return a proper JSON object response. Result was '{}'", (Object)responseBody);
            throw new IllegalStateException("Could not parse OpenID provider's malformed response");
        }
        catch (Exception e) {
            throw new IllegalStateException("invalid identity provider " + provider, e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public List<String> getScopes() {
        return Collections.unmodifiableList(this.scopes);
    }

    public boolean isAuthenticateNewUsers() {
        return this.authenticateNewUsers;
    }

    public boolean isLogoutWhenIdTokenIsExpired() {
        return this.logoutWhenIdTokenIsExpired;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public String getAuthEndpoint() {
        return this.authorizationEndpoint;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void setAuthenticateNewUsers(boolean authenticateNewUsers) {
        this.authenticateNewUsers = authenticateNewUsers;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void addScopes(String ... scopes) {
        if (scopes != null) {
            Collections.addAll(this.scopes, scopes);
        }
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void setLogoutWhenIdTokenIsExpired(boolean logoutWhenIdTokenIsExpired) {
        this.logoutWhenIdTokenIsExpired = logoutWhenIdTokenIsExpired;
    }

    private static HttpClient newHttpClient() {
        ClientConnector connector = new ClientConnector();
        connector.setSslContextFactory(new SslContextFactory.Client(false));
        return new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(connector));
    }

    public String toString() {
        return String.format("%s@%x{iss=%s, clientId=%s, authEndpoint=%s, authenticator=%s, tokenEndpoint=%s, scopes=%s, authNewUsers=%s}", TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode(), this.issuer, this.clientId, this.authorizationEndpoint, this.authenticationMethod, this.tokenEndpoint, this.scopes, this.authenticateNewUsers);
    }

    public static class Builder {
        private String issuer;
        private String clientId;
        private String clientSecret;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String endSessionEndpoint;
        private String authenticationMethod;
        private HttpClient httpClient;
        private boolean authenticateNewUsers = false;
        private boolean logoutWhenIdTokenIsExpired = false;
        private final List<String> scopes = new ArrayList<String>();

        public Builder() {
        }

        public Builder(@Name(value="issuer") String issuer, @Name(value="clientId") String clientId, @Name(value="clientSecret") String clientSecret) {
            this();
            this.issuer(issuer);
            this.clientId(clientId);
            this.clientSecret(clientSecret);
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public Builder endSessionEndpoint(String endSessionEndpoint) {
            this.endSessionEndpoint = endSessionEndpoint;
            return this;
        }

        public Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder authenticateNewUsers(boolean authenticateNewUsers) {
            this.authenticateNewUsers = authenticateNewUsers;
            return this;
        }

        public Builder scopes(String ... scopes) {
            if (scopes != null) {
                Collections.addAll(this.scopes, scopes);
            }
            return this;
        }

        public Builder logoutWhenIdTokenIsExpired(boolean logoutWhenIdTokenIsExpired) {
            this.logoutWhenIdTokenIsExpired = logoutWhenIdTokenIsExpired;
            return this;
        }

        public OpenIdConfiguration build() {
            if (this.issuer == null) {
                throw new IllegalArgumentException("Issuer was not configured");
            }
            if (this.clientId == null) {
                throw new IllegalArgumentException("clientId was not configured");
            }
            if (this.clientSecret == null) {
                throw new IllegalArgumentException("clientSecret was not configured");
            }
            return new OpenIdConfiguration(this.issuer, this.clientId, this.clientSecret, this.authorizationEndpoint, this.tokenEndpoint, this.endSessionEndpoint, this.authenticationMethod, this.httpClient, this.authenticateNewUsers, this.logoutWhenIdTokenIsExpired, this.scopes);
        }
    }
}

