/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jetty.maven.plugin.MavenAnnotationConfiguration;
import org.eclipse.jetty.maven.plugin.MavenWebInfConfiguration;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyWebAppContext
extends WebAppContext {
    private static final Logger LOG = Log.getLogger(JettyWebAppContext.class);
    private static final String DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN = ".*/javax.servlet-[^/]*\\.jar$|.*/servlet-api-[^/]*\\.jar$";
    private static final String WEB_INF_CLASSES_PREFIX = "/WEB-INF/classes";
    private static final String WEB_INF_LIB_PREFIX = "/WEB-INF/lib";
    private File _classes = null;
    private File _testClasses = null;
    private final List<File> _webInfClasses = new ArrayList<File>();
    private final List<File> _webInfJars = new ArrayList<File>();
    private final Map<String, File> _webInfJarMap = new HashMap<String, File>();
    private final EnvConfiguration _envConfig;
    private List<File> _classpathFiles;
    private String _jettyEnvXml;
    private List<Overlay> _overlays;
    private String _containerIncludeJarPattern = null;
    private String _webInfIncludeJarPattern = null;
    private boolean _baseAppFirst = true;

    public JettyWebAppContext() throws Exception {
        Configuration[] configurationArray = new Configuration[8];
        configurationArray[0] = new MavenWebInfConfiguration();
        configurationArray[1] = new WebXmlConfiguration();
        configurationArray[2] = new MetaInfConfiguration();
        configurationArray[3] = new FragmentConfiguration();
        this._envConfig = new EnvConfiguration();
        configurationArray[4] = this._envConfig;
        configurationArray[5] = new PlusConfiguration();
        configurationArray[6] = new MavenAnnotationConfiguration();
        configurationArray[7] = new JettyWebXmlConfiguration();
        this.setConfigurations(configurationArray);
        super.setCopyWebInf(false);
    }

    public void setContainerIncludeJarPattern(String pattern) {
        this._containerIncludeJarPattern = pattern;
    }

    public String getContainerIncludeJarPattern() {
        return this._containerIncludeJarPattern;
    }

    public String getWebInfIncludeJarPattern() {
        return this._webInfIncludeJarPattern;
    }

    public void setWebInfIncludeJarPattern(String pattern) {
        this._webInfIncludeJarPattern = pattern;
    }

    public List<File> getClassPathFiles() {
        return this._classpathFiles;
    }

    public void setJettyEnvXml(String jettyEnvXml) {
        this._jettyEnvXml = jettyEnvXml;
    }

    public String getJettyEnvXml() {
        return this._jettyEnvXml;
    }

    public void setClasses(File dir) {
        this._classes = dir;
    }

    public File getClasses() {
        return this._classes;
    }

    public void setWebInfLib(List<File> jars) {
        this._webInfJars.addAll(jars);
    }

    public void setTestClasses(File dir) {
        this._testClasses = dir;
    }

    public File getTestClasses() {
        return this._testClasses;
    }

    public void setOverlays(List<Overlay> overlays) {
        this._overlays = overlays;
    }

    public List<Overlay> getOverlays() {
        return this._overlays;
    }

    public void setBaseAppFirst(boolean value) {
        this._baseAppFirst = value;
    }

    public boolean getBaseAppFirst() {
        return this._baseAppFirst;
    }

    public void setResourceBases(String[] resourceBases) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String rl : resourceBases) {
            String[] rs;
            for (String r : rs = rl.split(" *, *")) {
                resources.add(r);
            }
        }
        this.setBaseResource((Resource)new ResourceCollection(resources.toArray(new String[resources.size()])));
    }

    public List<File> getWebInfLib() {
        return this._webInfJars;
    }

    public void doStart() throws Exception {
        String tmp = this._containerIncludeJarPattern;
        if (tmp == null || "".equals(tmp)) {
            tmp = (String)this.getAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern");
        }
        tmp = this.addPattern(tmp, DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN);
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", tmp);
        if (this._webInfIncludeJarPattern != null) {
            this.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", this._webInfIncludeJarPattern);
        }
        if (this._testClasses != null) {
            this._webInfClasses.add(this._testClasses);
        }
        if (this._classes != null) {
            this._webInfClasses.add(this._classes);
        }
        this._classpathFiles = new ArrayList<File>();
        this._classpathFiles.addAll(this._webInfClasses);
        this._classpathFiles.addAll(this._webInfJars);
        this._webInfJarMap.clear();
        for (File file : this._webInfJars) {
            String fileName = file.getName();
            if (!fileName.endsWith(".jar")) continue;
            this._webInfJarMap.put(fileName, file);
        }
        if (this._jettyEnvXml != null) {
            this._envConfig.setJettyEnvXml(Resource.toURL((File)new File(this._jettyEnvXml)));
        }
        super.doStart();
    }

    public void doStop() throws Exception {
        if (this._classpathFiles != null) {
            this._classpathFiles.clear();
        }
        this._classpathFiles = null;
        this._classes = null;
        this._testClasses = null;
        if (this._webInfJarMap != null) {
            this._webInfJarMap.clear();
        }
        this._webInfClasses.clear();
        this._webInfJars.clear();
        Thread.currentThread();
        Thread.sleep(500L);
        super.doStop();
        this.setEventListeners(new EventListener[0]);
        this.getServletHandler().setFilters(new FilterHolder[0]);
        this.getServletHandler().setFilterMappings(new FilterMapping[0]);
        this.getServletHandler().setServlets(new ServletHolder[0]);
        this.getServletHandler().setServletMappings(new ServletMapping[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource getResource(String uriInContext) throws MalformedURLException {
        Resource resource = null;
        resource = super.getResource(uriInContext);
        if (resource != null) {
            if (resource.exists()) return resource;
        }
        if (uriInContext == null) return resource;
        if (this._classes == null) return resource;
        String uri = URIUtil.canonicalPath((String)uriInContext);
        if (uri == null) {
            return null;
        }
        try {
            if (uri.startsWith(WEB_INF_CLASSES_PREFIX)) {
                if (uri.equalsIgnoreCase(WEB_INF_CLASSES_PREFIX) || uri.equalsIgnoreCase("/WEB-INF/classes/")) {
                    if (this._classes != null) {
                        return Resource.newResource((File)this._classes);
                    }
                    if (this._testClasses == null) return resource;
                    return Resource.newResource((File)this._testClasses);
                }
                Resource res = null;
                int i = 0;
                while (res == null) {
                    if (i >= this._webInfClasses.size()) return res;
                    String newPath = uri.replace(WEB_INF_CLASSES_PREFIX, this._webInfClasses.get(i).getPath());
                    res = Resource.newResource((String)newPath);
                    if (res.exists()) continue;
                    res = null;
                    ++i;
                }
                return res;
            }
            if (!uri.startsWith(WEB_INF_LIB_PREFIX)) return resource;
            String jarName = uri.replace(WEB_INF_LIB_PREFIX, "");
            if (jarName.startsWith("/") || jarName.startsWith("\\")) {
                jarName = jarName.substring(1);
            }
            if (jarName.length() == 0) {
                return null;
            }
            File jarFile = this._webInfJarMap.get(jarName);
            if (jarFile == null) return null;
            return Resource.newResource((String)jarFile.getPath());
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
        return resource;
    }

    public Set<String> getResourcePaths(String path) {
        Set paths = super.getResourcePaths(path);
        if (path != null) {
            TreeSet<String> allPaths = new TreeSet<String>();
            allPaths.addAll(paths);
            if (path.startsWith(WEB_INF_LIB_PREFIX)) {
                for (String fileName : this._webInfJarMap.keySet()) {
                    allPaths.add("/WEB-INF/lib/" + fileName);
                }
            } else if (path.startsWith(WEB_INF_CLASSES_PREFIX)) {
                for (int i = 0; i < this._webInfClasses.size(); ++i) {
                    String newPath = path.replace(WEB_INF_CLASSES_PREFIX, this._webInfClasses.get(i).getPath());
                    allPaths.addAll(super.getResourcePaths(newPath));
                }
            }
            return allPaths;
        }
        return paths;
    }

    public String addPattern(String s, String pattern) {
        if (!(s = s == null ? "" : s.trim()).contains(pattern)) {
            if (s.length() != 0) {
                s = s + "|";
            }
            s = s + pattern;
        }
        return s;
    }
}

