/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.SelectorUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;

public class SelectiveJarResource
extends JarResource {
    private static final Logger LOG = Log.getLogger(SelectiveJarResource.class);
    public static final List<String> DEFAULT_INCLUDES = Arrays.asList("**");
    public static final List<String> DEFAULT_EXCLUDES = Collections.emptyList();
    List<String> _includes = null;
    List<String> _excludes = null;
    boolean _caseSensitive = false;

    public SelectiveJarResource(URL url) {
        super(url);
    }

    public SelectiveJarResource(URL url, boolean useCaches) {
        super(url, useCaches);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public void setIncludes(List<String> patterns) {
        this._includes = patterns;
    }

    public void setExcludes(List<String> patterns) {
        this._excludes = patterns;
    }

    protected boolean isIncluded(String name) {
        for (String include : this._includes) {
            if (!SelectorUtils.matchPath((String)include, (String)name, (boolean)this._caseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        for (String exclude : this._excludes) {
            if (!SelectorUtils.matchPath((String)exclude, (String)name, (boolean)this._caseSensitive)) continue;
            return true;
        }
        return false;
    }

    public void copyTo(File directory) throws IOException {
        block34: {
            int startOfJarUrl;
            if (this._includes == null) {
                this._includes = DEFAULT_INCLUDES;
            }
            if (this._excludes == null) {
                this._excludes = DEFAULT_EXCLUDES;
            }
            if (!this.exists()) {
                return;
            }
            String urlString = this.getURI().toASCIIString().trim();
            int endOfJarUrl = urlString.indexOf("!/");
            int n = startOfJarUrl = endOfJarUrl >= 0 ? 4 : 0;
            if (endOfJarUrl < 0) {
                throw new IOException("Not a valid jar url: " + urlString);
            }
            URL jarFileURL = new URL(urlString.substring(startOfJarUrl, endOfJarUrl));
            try (InputStream is = jarFileURL.openConnection().getInputStream();
                 JarInputStream jin = new JarInputStream(is);){
                JarEntry entry;
                while ((entry = jin.getNextJarEntry()) != null) {
                    String entryName = entry.getName();
                    LOG.debug("Looking at " + entryName, new Object[0]);
                    String dotCheck = StringUtil.replace((String)entryName, (char)'\\', (char)'/');
                    dotCheck = URIUtil.canonicalPath((String)dotCheck);
                    if (dotCheck == null) {
                        LOG.info("Invalid entry: " + entryName, new Object[0]);
                        continue;
                    }
                    File file = new File(directory, entryName);
                    if (entry.isDirectory()) {
                        if (this.isIncluded(entryName)) {
                            if (!this.isExcluded(entryName)) {
                                if (file.exists()) continue;
                                file.mkdirs();
                                continue;
                            }
                            LOG.debug("{} dir is excluded", new Object[]{entryName});
                            continue;
                        }
                        LOG.debug("{} dir is NOT included", new Object[]{entryName});
                        continue;
                    }
                    if (this.isIncluded(entryName)) {
                        if (!this.isExcluded(entryName)) {
                            File dir = new File(file.getParent());
                            if (!dir.exists()) {
                                dir.mkdirs();
                            }
                            try (FileOutputStream fout = new FileOutputStream(file);){
                                IO.copy((InputStream)jin, (OutputStream)fout);
                            }
                            if (entry.getTime() < 0L) continue;
                            file.setLastModified(entry.getTime());
                            continue;
                        }
                        LOG.debug("{} file is excluded", new Object[]{entryName});
                        continue;
                    }
                    LOG.debug("{} file is NOT included", new Object[]{entryName});
                }
                Manifest manifest = jin.getManifest();
                if (manifest == null || !this.isIncluded("META-INF") || this.isExcluded("META-INF")) break block34;
                File metaInf = new File(directory, "META-INF");
                metaInf.mkdir();
                File f = new File(metaInf, "MANIFEST.MF");
                try (FileOutputStream fout = new FileOutputStream(f);){
                    manifest.write(fout);
                }
            }
        }
    }
}

