/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jspc.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jasper.JspC;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.resource.Resource;

public class JspcMojo
extends AbstractMojo {
    public static final String END_OF_WEBAPP = "</web-app>";
    private boolean useProvidedScope;
    private Set projectArtifacts;
    private MavenProject project;
    private List pluginArtifacts;
    private String webXmlFragment;
    private String insertionMarker;
    private boolean mergeFragment;
    private String generatedClasses;
    private boolean keepSources;
    private String packageRoot;
    private String webAppSourceDirectory;
    private String webXml;
    private String includes;
    private String excludes;
    private File classesDirectory;
    private boolean verbose;
    private boolean validateXml;
    private String javaEncoding;
    private boolean suppressSmap;
    private boolean ignoreJspFragmentErrors;
    private String schemaResourcePrefix;
    private String tldJarNamePatterns;
    private boolean trimSpaces = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("verbose=" + this.verbose));
            this.getLog().info((CharSequence)("webAppSourceDirectory=" + this.webAppSourceDirectory));
            this.getLog().info((CharSequence)("generatedClasses=" + this.generatedClasses));
            this.getLog().info((CharSequence)("webXmlFragment=" + this.webXmlFragment));
            this.getLog().info((CharSequence)("webXml=" + this.webXml));
            this.getLog().info((CharSequence)("validateXml=" + this.validateXml));
            this.getLog().info((CharSequence)("packageRoot=" + this.packageRoot));
            this.getLog().info((CharSequence)("javaEncoding=" + this.javaEncoding));
            this.getLog().info((CharSequence)("insertionMarker=" + (this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker)));
            this.getLog().info((CharSequence)("keepSources=" + this.keepSources));
            this.getLog().info((CharSequence)("mergeFragment=" + this.mergeFragment));
            this.getLog().info((CharSequence)("suppressSmap=" + this.suppressSmap));
            this.getLog().info((CharSequence)("ignoreJspFragmentErrors=" + this.ignoreJspFragmentErrors));
            this.getLog().info((CharSequence)("schemaResourcePrefix=" + this.schemaResourcePrefix));
            this.getLog().info((CharSequence)("trimSpaces=" + this.trimSpaces));
        }
        try {
            this.prepare();
            this.compile();
            this.cleanupSrcs();
            this.mergeWebXml();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure processing jsps", e);
        }
    }

    public void compile() throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        List<URL> webAppUrls = this.setUpWebAppClassPath();
        String sysClassPath = this.setUpSysClassPath();
        List<URL> tldJarUrls = this.getSystemJarsWithTlds();
        for (URL u : tldJarUrls) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(" sys jar with tlds: " + u));
            }
            webAppUrls.add(u);
        }
        URLClassLoader webAppClassLoader = new URLClassLoader(webAppUrls.toArray(new URL[0]), currentClassLoader);
        StringBuffer webAppClassPath = new StringBuffer();
        for (int i = 0; i < webAppUrls.size(); ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("webappclassloader contains: " + webAppUrls.get(i)));
            }
            webAppClassPath.append(new File(webAppUrls.get(i).toURI()).getCanonicalPath());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("added to classpath: " + webAppUrls.get(i).getFile()));
            }
            if (i + 1 >= webAppUrls.size()) continue;
            webAppClassPath.append(System.getProperty("path.separator"));
        }
        Thread.currentThread().setContextClassLoader(webAppClassLoader);
        JspC jspc = new JspC();
        jspc.setWebXmlFragment(this.webXmlFragment);
        jspc.setUriroot(this.webAppSourceDirectory);
        jspc.setPackage(this.packageRoot);
        jspc.setOutputDir(this.generatedClasses);
        jspc.setValidateXml(this.validateXml);
        jspc.setClassPath(webAppClassPath.toString());
        jspc.setCompile(true);
        jspc.setSmapSuppressed(this.suppressSmap);
        jspc.setSmapDumped(!this.suppressSmap);
        jspc.setJavaEncoding(this.javaEncoding);
        jspc.setTrimSpaces(this.trimSpaces);
        jspc.setSystemClassPath(sysClassPath);
        String jspFiles = this.getJspFiles(this.webAppSourceDirectory);
        this.getLog().info((CharSequence)("Compiling " + jspFiles));
        this.getLog().info((CharSequence)("Includes=" + this.includes));
        this.getLog().info((CharSequence)("Excludes=" + this.excludes));
        jspc.setJspFiles(jspFiles);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Files selected to precompile: " + jspFiles));
        }
        try {
            jspc.setIgnoreJspFragmentErrors(this.ignoreJspFragmentErrors);
        }
        catch (NoSuchMethodError e) {
            this.getLog().debug((CharSequence)"Tomcat Jasper does not support configuration option 'ignoreJspFragmentErrors': ignored");
        }
        try {
            if (this.schemaResourcePrefix != null) {
                JspC.setSchemaResourcePrefix((String)this.schemaResourcePrefix);
            }
        }
        catch (NoSuchMethodError e) {
            this.getLog().debug((CharSequence)"Tomcat Jasper does not support configuration option 'schemaResourcePrefix': ignored");
        }
        if (this.verbose) {
            jspc.setVerbose(99);
        } else {
            jspc.setVerbose(0);
        }
        jspc.execute();
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    private String getJspFiles(String webAppSourceDirectory) throws Exception {
        List fileNames = FileUtils.getFileNames((File)new File(webAppSourceDirectory), (String)this.includes, (String)this.excludes, (boolean)false);
        return StringUtils.join((Object[])fileNames.toArray(new String[0]), (String)",");
    }

    public void cleanupSrcs() throws Exception {
        File generatedClassesDir;
        if (!this.keepSources && (generatedClassesDir = new File(this.generatedClasses)).exists() && generatedClassesDir.isDirectory()) {
            JspcMojo.delete(generatedClassesDir, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".java");
                }
            });
        }
    }

    static void delete(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    JspcMojo.delete(f, filter);
                    continue;
                }
                f.delete();
            }
        }
    }

    public void mergeWebXml() throws Exception {
        if (this.mergeFragment) {
            File webXml = this.getWebXmlFile();
            if (!webXml.exists()) {
                this.getLog().info((CharSequence)(webXml.toString() + " does not exist, cannot merge with generated fragment"));
                return;
            }
            File fragmentWebXml = new File(this.webXmlFragment);
            if (!fragmentWebXml.exists()) {
                this.getLog().info((CharSequence)"No fragment web.xml file generated");
            }
            File mergedWebXml = new File(fragmentWebXml.getParentFile(), "web.xml");
            try (BufferedReader webXmlReader = new BufferedReader(new FileReader(webXml));
                 PrintWriter mergedWebXmlWriter = new PrintWriter(new FileWriter(mergedWebXml));){
                String marker;
                boolean atInsertPoint = false;
                boolean atEOF = false;
                String string = marker = this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker;
                while (!atInsertPoint && !atEOF) {
                    String line = webXmlReader.readLine();
                    if (line == null) {
                        atEOF = true;
                        continue;
                    }
                    if (line.indexOf(marker) >= 0) {
                        atInsertPoint = true;
                        continue;
                    }
                    mergedWebXmlWriter.println(line);
                }
                try (BufferedReader fragmentWebXmlReader = new BufferedReader(new FileReader(fragmentWebXml));){
                    IO.copy((Reader)fragmentWebXmlReader, (Writer)mergedWebXmlWriter);
                    if (marker.equals(END_OF_WEBAPP)) {
                        mergedWebXmlWriter.println(END_OF_WEBAPP);
                    }
                    IO.copy((Reader)webXmlReader, (Writer)mergedWebXmlWriter);
                }
            }
        }
    }

    private void prepare() throws Exception {
        File generatedSourceDirectoryFile = new File(this.generatedClasses);
        if (!generatedSourceDirectoryFile.exists()) {
            generatedSourceDirectoryFile.mkdirs();
        }
    }

    private List<URL> setUpWebAppClassPath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        String classesDir = this.classesDirectory.getCanonicalPath();
        classesDir = classesDir + (classesDir.endsWith(File.pathSeparator) ? "" : File.separator);
        urls.add(Resource.toURL((File)new File(classesDir)));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding to classpath classes dir: " + classesDir));
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("test".equals(artifact.getScope()) || "provided".equals(artifact.getScope())) continue;
            String filePath = artifact.getFile().getCanonicalPath();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding to classpath dependency file: " + filePath));
            }
            urls.add(Resource.toURL((File)artifact.getFile()));
        }
        return urls;
    }

    private String setUpSysClassPath() throws Exception {
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.pluginArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact pluginArtifact = (Artifact)iter.next();
            if (!"jar".equalsIgnoreCase(pluginArtifact.getType())) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding plugin artifact " + pluginArtifact));
            }
            buff.append(pluginArtifact.getFile().getAbsolutePath());
            if (!iter.hasNext()) continue;
            buff.append(File.pathSeparator);
        }
        if (this.useProvidedScope) {
            for (Artifact artifact : this.projectArtifacts) {
                if (!"provided".equals(artifact.getScope())) continue;
                String path = artifact.getFile().getAbsolutePath();
                if (!buff.toString().contains(path)) {
                    if (buff.length() != 0) {
                        buff.append(File.pathSeparator);
                    }
                    buff.append(path);
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
                    continue;
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping provided artifact: " + artifact));
            }
        }
        return buff.toString();
    }

    private List<URL> getSystemJarsWithTlds() throws Exception {
        final ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<URI> artifactUris = new ArrayList<URI>();
        Pattern pattern = Pattern.compile(this.tldJarNamePatterns);
        for (Artifact pluginArtifact : this.pluginArtifacts) {
            artifactUris.add(Resource.newResource((File)pluginArtifact.getFile()).getURI());
        }
        PatternMatcher matcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                list.add(uri.toURL());
            }
        };
        matcher.match(pattern, artifactUris.toArray(new URI[artifactUris.size()]), false);
        return list;
    }

    private File getWebXmlFile() throws IOException {
        File file = null;
        File baseDir = this.project.getBasedir().getCanonicalFile();
        File defaultWebAppSrcDir = new File(baseDir, "src/main/webapp").getCanonicalFile();
        File webAppSrcDir = new File(this.webAppSourceDirectory).getCanonicalFile();
        File defaultWebXml = new File(defaultWebAppSrcDir, "web.xml").getCanonicalFile();
        File webXmlFile = new File(this.webXml).getCanonicalFile();
        if (webXmlFile.compareTo(defaultWebXml) != 0) {
            file = new File(this.webXml);
            return file;
        }
        file = new File(webAppSrcDir, "web.xml");
        return file;
    }
}

