/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseLoginModule
extends AbstractLoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDatabaseLoginModule.class);
    private String userQuery;
    private String rolesQuery;
    private String dbUserTable;
    private String dbUserTableUserField;
    private String dbUserTableCredentialField;
    private String dbUserRoleTable;
    private String dbUserRoleTableUserField;
    private String dbUserRoleTableRoleField;

    public abstract Connection getConnection() throws Exception;

    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        try (Connection connection = this.getConnection();){
            JDBCUserInfo jDBCUserInfo;
            String dbCredential = null;
            try (PreparedStatement statement = connection.prepareStatement(this.userQuery);){
                statement.setString(1, userName);
                try (ResultSet results = statement.executeQuery();){
                    if (results.next()) {
                        dbCredential = results.getString(1);
                    }
                }
            }
            if (dbCredential == null) {
                jDBCUserInfo = null;
                return jDBCUserInfo;
            }
            jDBCUserInfo = new JDBCUserInfo(userName, Credential.getCredential((String)dbCredential));
            return jDBCUserInfo;
        }
    }

    public List<String> getRoles(String userName) throws Exception {
        ArrayList<String> roles = new ArrayList<String>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.rolesQuery);){
            statement.setString(1, userName);
            try (ResultSet results = statement.executeQuery();){
                while (results.next()) {
                    String roleName = results.getString(1);
                    roles.add(roleName);
                }
            }
        }
        return roles;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dbUserTable = (String)options.get("userTable");
        this.dbUserTableUserField = (String)options.get("userField");
        this.dbUserTableCredentialField = (String)options.get("credentialField");
        this.userQuery = "select " + this.dbUserTableCredentialField + " from " + this.dbUserTable + " where " + this.dbUserTableUserField + "=?";
        this.dbUserRoleTable = (String)options.get("userRoleTable");
        this.dbUserRoleTableUserField = (String)options.get("userRoleUserField");
        this.dbUserRoleTableRoleField = (String)options.get("userRoleRoleField");
        this.rolesQuery = "select " + this.dbUserRoleTableRoleField + " from " + this.dbUserRoleTable + " where " + this.dbUserRoleTableUserField + "=?";
        if (LOG.isDebugEnabled()) {
            LOG.debug("userQuery = " + this.userQuery);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rolesQuery = " + this.rolesQuery);
        }
    }

    public class JDBCUserInfo
    extends UserInfo {
        public JDBCUserInfo(String userName, Credential credential) {
            super(userName, credential);
        }

        @Override
        public List<String> doFetchRoles() throws Exception {
            return AbstractDatabaseLoginModule.this.getRoles(this.getUserName());
        }
    }
}

