/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.session.AbstractSessionDataStore;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.UnreadableSessionDataException;
import org.eclipse.jetty.session.infinispan.InfinispanKeyBuilder;
import org.eclipse.jetty.session.infinispan.InfinispanSessionData;
import org.eclipse.jetty.session.infinispan.QueryManager;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.infinispan.commons.api.BasicCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class InfinispanSessionDataStore
extends AbstractSessionDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(InfinispanSessionDataStore.class);
    private BasicCache<String, InfinispanSessionData> _cache;
    private int _infinispanIdleTimeoutSec;
    private QueryManager _queryManager;
    private boolean _passivating;
    private boolean _serialization;

    public BasicCache<String, InfinispanSessionData> getCache() {
        return this._cache;
    }

    public void setCache(BasicCache<String, InfinispanSessionData> cache) {
        this._cache = cache;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        try {
            Class<?> remoteClass = InfinispanSessionDataStore.class.getClassLoader().loadClass("org.infinispan.client.hotrod.RemoteCache");
            if (remoteClass.isAssignableFrom(this._cache.getClass()) || this._serialization) {
                this._passivating = true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.info("Hotrod classes not found, assuming infinispan in embedded mode");
        }
    }

    public QueryManager getQueryManager() {
        return this._queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this._queryManager = queryManager;
    }

    public SessionData doLoad(String id) throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading session {} from infinispan", (Object)id);
            }
            InfinispanSessionData sd = (InfinispanSessionData)((Object)this._cache.get((Object)this.getCacheKey(id)));
            if (this.isPassivating() && sd != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deserializing session attributes for {}", (Object)id);
                }
                sd.deserializeAttributes();
            }
            return sd;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting session with id {} from infinispan", (Object)id);
        }
        return this._cache.remove((Object)this.getCacheKey(id)) != null;
    }

    public Set<String> doCheckExpired(Set<String> candidates, long time) {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        HashSet<String> expired = new HashSet<String>();
        for (String candidate : candidates) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking expiry for candidate {}", (Object)candidate);
            }
            try {
                SessionData sd = this.load(candidate);
                if (sd == null) {
                    expired.add(candidate);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Session {} does not exist in infinispan", (Object)candidate);
                    continue;
                }
                if (!this._context.getWorkerName().equals(sd.getLastNode()) || sd.getExpiry() <= 0L || sd.getExpiry() > time) continue;
                expired.add(candidate);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Session {} managed by {} is expired", (Object)candidate, (Object)this._context.getWorkerName());
            }
            catch (Exception e) {
                LOG.warn("Error checking if candidate {} is expired", (Object)candidate, (Object)e);
            }
        }
        return expired;
    }

    public Set<String> doGetExpired(long time) {
        if (this._queryManager != null) {
            HashSet<String> expired = new HashSet<String>();
            for (String sessionId : this._queryManager.queryExpiredSessions(this._context, time)) {
                expired.add(sessionId);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}- Found expired sessionId={}", (Object)this._context.getWorkerName(), (Object)sessionId);
            }
            return expired;
        }
        return Collections.emptySet();
    }

    public void doCleanOrphans(long timeLimit) {
        if (this._queryManager != null) {
            this._queryManager.deleteOrphanSessions(timeLimit);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to clean orphans, no QueryManager");
        }
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (this.isPassivating() && data != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serializing session attributes for {}", (Object)id);
            }
            ((InfinispanSessionData)data).serializeAttributes();
        }
        if (data.getMaxInactiveMs() > 0L && this.getInfinispanIdleTimeoutSec() > 0) {
            this._cache.put((Object)this.getCacheKey(id), (Object)((InfinispanSessionData)data), -1L, TimeUnit.MILLISECONDS, (long)this.getInfinispanIdleTimeoutSec(), TimeUnit.SECONDS);
        } else {
            this._cache.put((Object)this.getCacheKey(id), (Object)((InfinispanSessionData)data));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {} saved to infinispan, expires {} ", (Object)id, (Object)data.getExpiry());
        }
    }

    public String getCacheKey(String id) {
        return InfinispanKeyBuilder.build(this._context.getCanonicalContextPath(), this._context.getVhost(), id);
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return this._passivating;
    }

    public boolean doExists(String id) throws Exception {
        if (this._queryManager != null) {
            return this._queryManager.exists(this._context, id);
        }
        SessionData sd = this.doLoad(id);
        if (sd == null) {
            return false;
        }
        if (sd.getExpiry() <= 0L) {
            return true;
        }
        return sd.getExpiry() > System.currentTimeMillis();
    }

    public SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        return new InfinispanSessionData(id, this._context.getCanonicalContextPath(), this._context.getVhost(), created, accessed, lastAccessed, maxInactiveMs);
    }

    public void setInfinispanIdleTimeoutSec(int sec) {
        this._infinispanIdleTimeoutSec = sec;
    }

    @ManagedAttribute(value="infinispan idle timeout sec", readonly=true)
    public int getInfinispanIdleTimeoutSec() {
        return this._infinispanIdleTimeoutSec;
    }

    public void setSerialization(boolean serialization) {
        this._serialization = serialization;
    }

    public String toString() {
        return String.format("%s[cache=%s,idleTimeoutSec=%d]", super.toString(), this._cache == null ? "" : this._cache.getName(), this._infinispanIdleTimeoutSec);
    }
}

