/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServletPathSpecOrderTest {
    private static PathMappings<String> mappings = new PathMappings();
    @Parameterized.Parameter(value=0)
    public String inputPath;
    @Parameterized.Parameter(value=1)
    public String expectedResource;

    @Parameterized.Parameters(name="{0} = {1}")
    public static List<String[]> testCases() {
        String[][] data = new String[][]{{"/abs/path", "abspath"}, {"/abs/path/xxx", "default"}, {"/abs/pith", "default"}, {"/abs/path/longer", "longpath"}, {"/abs/path/", "default"}, {"/abs/path/foo", "default"}, {"/animal/bird/eagle/bald", "birds"}, {"/animal/fish/shark/hammerhead", "fishes"}, {"/animal/insect/ladybug", "animals"}, {"/animal", "animals"}, {"/animal/", "animals"}, {"/animal/other", "animals"}, {"/animal/*", "animals"}, {"/downloads/distribution.tar.gz", "tarball"}, {"/downloads/script.gz", "gzipped"}, {"/animal/arhive.gz", "animals"}, {"/Other/path", "default"}, {"/\u20acuro/path", "money"}, {"/", "root"}, {"/downloads/readme.txt", "default"}, {"/downloads/logs.tgz", "default"}, {"/main.css", "default"}};
        return Arrays.asList(data);
    }

    @Test
    public void testMatch() {
        Assert.assertThat((String)("Match on [" + this.inputPath + "]"), (Object)((String)mappings.getMatch(this.inputPath).getResource()), (Matcher)Matchers.is((Object)this.expectedResource));
    }

    static {
        mappings.put((PathSpec)new ServletPathSpec("/abs/path"), (Object)"abspath");
        mappings.put((PathSpec)new ServletPathSpec("/abs/path/longer"), (Object)"longpath");
        mappings.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        mappings.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        mappings.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        mappings.put((PathSpec)new ServletPathSpec("*.tar.gz"), (Object)"tarball");
        mappings.put((PathSpec)new ServletPathSpec("*.gz"), (Object)"gzipped");
        mappings.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        mappings.put((PathSpec)new ServletPathSpec(""), (Object)"root");
        mappings.put((PathSpec)new ServletPathSpec("/\u20acuro/*"), (Object)"money");
    }
}

