/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.MultiMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HttpURITest {
    @Test
    public void testInvalidAddress() throws Exception {
        this.assertInvalidURI("http://[ffff::1:8080/", "Invalid URL; no closing ']' -- should throw exception");
        this.assertInvalidURI("**", "only '*', not '**'");
        this.assertInvalidURI("*/", "only '*', not '*/'");
    }

    private void assertInvalidURI(String invalidURI, String message) {
        HttpURI uri = new HttpURI();
        try {
            uri.parse(invalidURI);
            Assert.fail((String)message);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testParse() {
        HttpURI uri = new HttpURI();
        uri.parse("*");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"*"));
        uri.parse("/foo/bar");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/foo/bar"));
        uri.parse("//foo/bar");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
        uri.parse("http://foo/bar");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
    }

    @Test
    public void testParseRequestTarget() {
        HttpURI uri = new HttpURI();
        uri.parseRequestTarget("GET", "*");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"*"));
        uri.parseRequestTarget("GET", "/foo/bar");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/foo/bar"));
        uri.parseRequestTarget("GET", "//foo/bar");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"//foo/bar"));
        uri.parseRequestTarget("GET", "http://foo/bar");
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
    }

    @Test
    public void testExtB() throws Exception {
        for (String value : new String[]{"a", "abcdABCD", "\u00c0", "\u697c", "\ud869\uded5", "\ud840\udc08"}) {
            HttpURI uri = new HttpURI("/path?value=" + URLEncoder.encode(value, "UTF-8"));
            MultiMap parameters = new MultiMap();
            uri.decodeQueryTo(parameters, StandardCharsets.UTF_8);
            Assert.assertEquals((Object)value, (Object)parameters.getString("value"));
        }
    }

    @Test
    public void testAt() throws Exception {
        HttpURI uri = new HttpURI("/@foo/bar");
        Assert.assertEquals((Object)"/@foo/bar", (Object)uri.getPath());
    }

    @Test
    public void testParams() throws Exception {
        HttpURI uri = new HttpURI("/foo/bar");
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals(null, (Object)uri.getParam());
        uri = new HttpURI("/foo/bar;jsessionid=12345");
        Assert.assertEquals((Object)"/foo/bar;jsessionid=12345", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345");
        Assert.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345?name=value");
        Assert.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345#target");
        Assert.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
    }

    @Test
    public void testMutableURI() {
        HttpURI uri = new HttpURI("/foo/bar");
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.toString());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setScheme("http");
        Assert.assertEquals((Object)"http:/foo/bar", (Object)uri.toString());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setAuthority("host", 0);
        Assert.assertEquals((Object)"http://host/foo/bar", (Object)uri.toString());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setAuthority("host", 8888);
        Assert.assertEquals((Object)"http://host:8888/foo/bar", (Object)uri.toString());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setPathQuery("/f%30%30;p0/bar;p1;p2");
        Assert.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2", (Object)uri.toString());
        Assert.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assert.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"p2", (Object)uri.getParam());
        Assert.assertEquals(null, (Object)uri.getQuery());
        uri.setPathQuery("/f%30%30;p0/bar;p1;p2?name=value");
        Assert.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2?name=value", (Object)uri.toString());
        Assert.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assert.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"p2", (Object)uri.getParam());
        Assert.assertEquals((Object)"name=value", (Object)uri.getQuery());
        uri.setQuery("other=123456");
        Assert.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2?other=123456", (Object)uri.toString());
        Assert.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assert.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assert.assertEquals((Object)"p2", (Object)uri.getParam());
        Assert.assertEquals((Object)"other=123456", (Object)uri.getQuery());
    }

    @Test
    public void testSchemeAndOrAuthority() throws Exception {
        HttpURI uri = new HttpURI("/path/info");
        Assert.assertEquals((Object)"/path/info", (Object)uri.toString());
        uri.setAuthority("host", 0);
        Assert.assertEquals((Object)"//host/path/info", (Object)uri.toString());
        uri.setAuthority("host", 8888);
        Assert.assertEquals((Object)"//host:8888/path/info", (Object)uri.toString());
        uri.setScheme("http");
        Assert.assertEquals((Object)"http://host:8888/path/info", (Object)uri.toString());
        uri.setAuthority(null, 0);
        Assert.assertEquals((Object)"http:/path/info", (Object)uri.toString());
    }

    @Test
    public void testBasicAuthCredentials() throws Exception {
        HttpURI uri = new HttpURI("http://user:password@example.com:8888/blah");
        Assert.assertEquals((Object)"http://user:password@example.com:8888/blah", (Object)uri.toString());
        Assert.assertEquals((Object)uri.getAuthority(), (Object)"example.com:8888");
        Assert.assertEquals((Object)uri.getUser(), (Object)"user:password");
    }
}

