/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UriTemplatePathSpecBadSpecsTest {
    private String pathSpec;

    private static void bad(List<String[]> data, String str) {
        data.add(new String[]{str});
    }

    @Parameterized.Parameters
    public static Collection<String[]> data() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/b{var}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "a/{var}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/{var/b}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/{var}/*");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/{var}.do");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/{var*}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/{}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "{var}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/{my special variable}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/{var}/{var}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/../../../{var}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a/./{var}");
        UriTemplatePathSpecBadSpecsTest.bad(data, "/a//{var}");
        return data;
    }

    public UriTemplatePathSpecBadSpecsTest(String pathSpec) {
        this.pathSpec = pathSpec;
    }

    @Test
    public void testBadPathSpec() {
        try {
            new UriTemplatePathSpec(this.pathSpec);
            Assert.fail((String)("Expected IllegalArgumentException for a bad PathParam pathspec on: " + this.pathSpec));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }
}

