/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServletPathSpecMatchListTest {
    private static PathMappings<String> mappings = new PathMappings();
    @Parameterized.Parameter(value=0)
    public String message;
    @Parameterized.Parameter(value=1)
    public String inputPath;
    @Parameterized.Parameter(value=2)
    public String expectedListing;

    @Parameterized.Parameters(name="{0} = {1}")
    public static List<String[]> testCases() {
        String[][] data = new String[][]{{"All matches", "/animal/bird/path.tar.gz", "[/animal/bird/*=birds, /animal/*=animals, *.tar.gz=tarball, *.gz=gzipped, /=default]"}, {"Dir matches", "/animal/fish/", "[/animal/fish/*=fishes, /animal/*=animals, /=default]"}, {"Dir matches", "/animal/fish", "[/animal/fish/*=fishes, /animal/*=animals, /=default]"}, {"Root matches", "/", "[=root, /=default]"}, {"Dir matches", "", "[/=default]"}};
        return Arrays.asList(data);
    }

    @Test
    public void testGetMatches() {
        List matches = mappings.getMatches(this.inputPath);
        StringBuilder actual = new StringBuilder();
        actual.append('[');
        boolean delim = false;
        for (MappedResource res : matches) {
            if (delim) {
                actual.append(", ");
            }
            actual.append(res.getPathSpec().pathSpec).append('=').append((String)res.getResource());
            delim = true;
        }
        actual.append(']');
        Assert.assertThat((String)(this.message + " on [" + this.inputPath + "]"), (Object)actual.toString(), (Matcher)Matchers.is((Object)this.expectedListing));
    }

    static {
        mappings.put((PathSpec)new ServletPathSpec("/abs/path"), (Object)"abspath");
        mappings.put((PathSpec)new ServletPathSpec("/abs/path/longer"), (Object)"longpath");
        mappings.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        mappings.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        mappings.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        mappings.put((PathSpec)new ServletPathSpec("*.tar.gz"), (Object)"tarball");
        mappings.put((PathSpec)new ServletPathSpec("*.gz"), (Object)"gzipped");
        mappings.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        mappings.put((PathSpec)new ServletPathSpec(""), (Object)"root");
        mappings.put((PathSpec)new ServletPathSpec("/\u20acuro/*"), (Object)"money");
    }
}

