/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RegexPathSpecTest {
    public static void assertMatches(PathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)true));
    }

    public static void assertNotMatches(PathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExactSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/a$");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"^/a$", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)1L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.EXACT, (Object)spec.group);
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a/");
    }

    @Test
    public void testMiddleSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/rest/([^/]*)/list$");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"^/rest/([^/]*)/list$", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/rest/([^/]*)/list$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)3L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.group);
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/api/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/1.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/2.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/accounts/list");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/admin/delete");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/list");
    }

    @Test
    public void testMiddleSpecNoGrouping() {
        RegexPathSpec spec = new RegexPathSpec("^/rest/[^/]+/list$");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"^/rest/[^/]+/list$", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/rest/[^/]+/list$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)3L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.group);
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/api/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/1.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/2.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/accounts/list");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/admin/delete");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/list");
    }

    @Test
    public void testPrefixSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/a/(.*)$");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"^/a/(.*)$", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a/(.*)$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)2L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.group);
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c/d/e");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
    }

    @Test
    public void testSuffixSpec() {
        RegexPathSpec spec = new RegexPathSpec("^(.*).do$");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"^(.*).do$", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^(.*).do$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)0L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.group);
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/abcde.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/abc/efg.do");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb.do/more");
    }
}

