/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.QuotedQualityCSV;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class QuotedQualityCSVTest {
    @Test
    public void test7231_5_3_2_example1() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue(" audio/*; q=0.2, audio/basic");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"audio/basic", "audio/*"}));
    }

    @Test
    public void test7231_5_3_2_example2() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("text/plain; q=0.5, text/html,");
        values.addValue("text/x-dvi; q=0.8, text/x-c");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/html", "text/x-c", "text/x-dvi", "text/plain"}));
    }

    @Test
    public void test7231_5_3_2_example3() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("text/*, text/plain, text/plain;format=flowed, */*");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/plain;format=flowed", "text/plain", "text/*", "*/*"}));
    }

    @Test
    public void test7231_5_3_2_example4() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("text/*;q=0.3, text/html;q=0.7, text/html;level=1,");
        values.addValue("text/html;level=2;q=0.4, */*;q=0.5");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/html;level=1", "text/html", "*/*", "text/html;level=2", "text/*"}));
    }

    @Test
    public void test7231_5_3_4_example1() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("compress, gzip");
        values.addValue("");
        values.addValue("*");
        values.addValue("compress;q=0.5, gzip;q=1.0");
        values.addValue("gzip;q=1.0, identity; q=0.5, *;q=0");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"compress", "gzip", "gzip", "gzip", "*", "compress", "identity"}));
    }

    @Test
    public void testOWS() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("  value 0.5  ;  p = v  ;  q =0.5  ,  value 1.0 ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 1.0", "value 0.5;p=v"}));
    }

    @Test
    public void testEmpty() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue(",aaaa,  , bbbb ,,cccc,");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"aaaa", "bbbb", "cccc"}));
    }

    @Test
    public void testQuoted() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("  value 0.5  ;  p = \"v  ;  q = \\\"0.5\\\"  ,  value 1.0 \"  ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 0.5;p=\"v  ;  q = \\\"0.5\\\"  ,  value 1.0 \""}));
    }

    @Test
    public void testOpenQuote() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("value;p=\"v");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=\"v"}));
    }

    @Test
    public void testQuotedQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("  value 0.5  ;  p = v  ;  q = \"0.5\"  ,  value 1.0 ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 1.0", "value 0.5;p=v"}));
    }

    @Test
    public void testBadQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV(new String[0]);
        values.addValue("value0.5;p=v;q=0.5,value1.0,valueBad;q=X");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value1.0", "value0.5;p=v"}));
    }
}

