/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.PathMap;
import org.junit.Assert;
import org.junit.Test;

public class PathMapTest {
    @Test
    public void testPathMap() throws Exception {
        String[][] tests;
        PathMap p = new PathMap();
        p.put("/abs/path", (Object)"1");
        p.put("/abs/path/longer", (Object)"2");
        p.put("/animal/bird/*", (Object)"3");
        p.put("/animal/fish/*", (Object)"4");
        p.put("/animal/*", (Object)"5");
        p.put("*.tar.gz", (Object)"6");
        p.put("*.gz", (Object)"7");
        p.put("/", (Object)"8");
        p.put("/XXX:/YYY", (Object)"9");
        p.put("", (Object)"10");
        p.put("/\u20acuro/*", (Object)"11");
        for (String[] test : tests = new String[][]{{"/abs/path", "1"}, {"/abs/path/xxx", "8"}, {"/abs/pith", "8"}, {"/abs/path/longer", "2"}, {"/abs/path/", "8"}, {"/abs/path/xxx", "8"}, {"/animal/bird/eagle/bald", "3"}, {"/animal/fish/shark/grey", "4"}, {"/animal/insect/bug", "5"}, {"/animal", "5"}, {"/animal/", "5"}, {"/animal/x", "5"}, {"/animal/*", "5"}, {"/suffix/path.tar.gz", "6"}, {"/suffix/path.gz", "7"}, {"/animal/path.gz", "5"}, {"/Other/path", "8"}, {"/\u20acuro/path", "11"}, {"/", "10"}}) {
            Assert.assertEquals((String)test[0], (Object)test[1], (Object)p.getMatch(test[0]).getValue());
        }
        Assert.assertEquals((String)"Get absolute path", (Object)"1", (Object)p.get((Object)"/abs/path"));
        Assert.assertEquals((String)"Match absolute path", (Object)"/abs/path", (Object)p.getMatch("/abs/path").getKey());
        Assert.assertEquals((String)"all matches", (Object)"[/animal/bird/*=3, /animal/*=5, *.tar.gz=6, *.gz=7, /=8]", (Object)p.getMatches("/animal/bird/path.tar.gz").toString());
        Assert.assertEquals((String)"Dir matches", (Object)"[/animal/fish/*=4, /animal/*=5, /=8]", (Object)p.getMatches("/animal/fish/").toString());
        Assert.assertEquals((String)"Dir matches", (Object)"[/animal/fish/*=4, /animal/*=5, /=8]", (Object)p.getMatches("/animal/fish").toString());
        Assert.assertEquals((String)"Root matches", (Object)"[=10, /=8]", (Object)p.getMatches("/").toString());
        Assert.assertEquals((String)"Dir matches", (Object)"[/=8]", (Object)p.getMatches("").toString());
        Assert.assertEquals((String)"pathMatch exact", (Object)"/Foo/bar", (Object)PathMap.pathMatch((String)"/Foo/bar", (String)"/Foo/bar"));
        Assert.assertEquals((String)"pathMatch prefix", (Object)"/Foo", (Object)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo/bar"));
        Assert.assertEquals((String)"pathMatch prefix", (Object)"/Foo", (Object)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo/"));
        Assert.assertEquals((String)"pathMatch prefix", (Object)"/Foo", (Object)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo"));
        Assert.assertEquals((String)"pathMatch suffix", (Object)"/Foo/bar.ext", (Object)PathMap.pathMatch((String)"*.ext", (String)"/Foo/bar.ext"));
        Assert.assertEquals((String)"pathMatch default", (Object)"/Foo/bar.ext", (Object)PathMap.pathMatch((String)"/", (String)"/Foo/bar.ext"));
        Assert.assertEquals((String)"pathInfo exact", null, (Object)PathMap.pathInfo((String)"/Foo/bar", (String)"/Foo/bar"));
        Assert.assertEquals((String)"pathInfo prefix", (Object)"/bar", (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/bar"));
        Assert.assertEquals((String)"pathInfo prefix", (Object)"/*", (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/*"));
        Assert.assertEquals((String)"pathInfo prefix", (Object)"/", (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/"));
        Assert.assertEquals((String)"pathInfo prefix", null, (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo"));
        Assert.assertEquals((String)"pathInfo suffix", null, (Object)PathMap.pathInfo((String)"*.ext", (String)"/Foo/bar.ext"));
        Assert.assertEquals((String)"pathInfo default", null, (Object)PathMap.pathInfo((String)"/", (String)"/Foo/bar.ext"));
        Assert.assertEquals((String)"multi paths", (Object)"9", (Object)p.getMatch("/XXX").getValue());
        Assert.assertEquals((String)"multi paths", (Object)"9", (Object)p.getMatch("/YYY").getValue());
        p.put("/*", (Object)"0");
        Assert.assertEquals((String)"Get absolute path", (Object)"1", (Object)p.get((Object)"/abs/path"));
        Assert.assertEquals((String)"Match absolute path", (Object)"/abs/path", (Object)p.getMatch("/abs/path").getKey());
        Assert.assertEquals((String)"Match absolute path", (Object)"1", (Object)p.getMatch("/abs/path").getValue());
        Assert.assertEquals((String)"Mismatch absolute path", (Object)"0", (Object)p.getMatch("/abs/path/xxx").getValue());
        Assert.assertEquals((String)"Mismatch absolute path", (Object)"0", (Object)p.getMatch("/abs/pith").getValue());
        Assert.assertEquals((String)"Match longer absolute path", (Object)"2", (Object)p.getMatch("/abs/path/longer").getValue());
        Assert.assertEquals((String)"Not exact absolute path", (Object)"0", (Object)p.getMatch("/abs/path/").getValue());
        Assert.assertEquals((String)"Not exact absolute path", (Object)"0", (Object)p.getMatch("/abs/path/xxx").getValue());
        Assert.assertEquals((String)"Match longest prefix", (Object)"3", (Object)p.getMatch("/animal/bird/eagle/bald").getValue());
        Assert.assertEquals((String)"Match longest prefix", (Object)"4", (Object)p.getMatch("/animal/fish/shark/grey").getValue());
        Assert.assertEquals((String)"Match longest prefix", (Object)"5", (Object)p.getMatch("/animal/insect/bug").getValue());
        Assert.assertEquals((String)"mismatch exact prefix", (Object)"5", (Object)p.getMatch("/animal").getValue());
        Assert.assertEquals((String)"mismatch exact prefix", (Object)"5", (Object)p.getMatch("/animal/").getValue());
        Assert.assertEquals((String)"Match longest suffix", (Object)"0", (Object)p.getMatch("/suffix/path.tar.gz").getValue());
        Assert.assertEquals((String)"Match longest suffix", (Object)"0", (Object)p.getMatch("/suffix/path.gz").getValue());
        Assert.assertEquals((String)"prefix rather than suffix", (Object)"5", (Object)p.getMatch("/animal/path.gz").getValue());
        Assert.assertEquals((String)"default", (Object)"0", (Object)p.getMatch("/Other/path").getValue());
        Assert.assertEquals((String)"pathMatch /*", (Object)"", (Object)PathMap.pathMatch((String)"/*", (String)"/xxx/zzz"));
        Assert.assertEquals((String)"pathInfo /*", (Object)"/xxx/zzz", (Object)PathMap.pathInfo((String)"/*", (String)"/xxx/zzz"));
        Assert.assertTrue((String)"match /", (boolean)PathMap.match((String)"/", (String)"/anything"));
        Assert.assertTrue((String)"match /*", (boolean)PathMap.match((String)"/*", (String)"/anything"));
        Assert.assertTrue((String)"match /foo", (boolean)PathMap.match((String)"/foo", (String)"/foo"));
        Assert.assertTrue((String)"!match /foo", (!PathMap.match((String)"/foo", (String)"/bar") ? 1 : 0) != 0);
        Assert.assertTrue((String)"match /foo/*", (boolean)PathMap.match((String)"/foo/*", (String)"/foo"));
        Assert.assertTrue((String)"match /foo/*", (boolean)PathMap.match((String)"/foo/*", (String)"/foo/"));
        Assert.assertTrue((String)"match /foo/*", (boolean)PathMap.match((String)"/foo/*", (String)"/foo/anything"));
        Assert.assertTrue((String)"!match /foo/*", (!PathMap.match((String)"/foo/*", (String)"/bar") ? 1 : 0) != 0);
        Assert.assertTrue((String)"!match /foo/*", (!PathMap.match((String)"/foo/*", (String)"/bar/") ? 1 : 0) != 0);
        Assert.assertTrue((String)"!match /foo/*", (!PathMap.match((String)"/foo/*", (String)"/bar/anything") ? 1 : 0) != 0);
        Assert.assertTrue((String)"match *.foo", (boolean)PathMap.match((String)"*.foo", (String)"anything.foo"));
        Assert.assertTrue((String)"!match *.foo", (!PathMap.match((String)"*.foo", (String)"anything.bar") ? 1 : 0) != 0);
        Assert.assertEquals((String)"match / with ''", (Object)"10", (Object)p.getMatch("/").getValue());
        Assert.assertTrue((String)"match \"\"", (boolean)PathMap.match((String)"", (String)"/"));
    }

    @Test
    public void testPathMappingsOnlyMatchOnDirectoryNames() throws Exception {
        String spec = "/xyz/*";
        this.assertMatch(spec, "/xyz");
        this.assertMatch(spec, "/xyz/");
        this.assertMatch(spec, "/xyz/123");
        this.assertMatch(spec, "/xyz/123/");
        this.assertMatch(spec, "/xyz/123.txt");
        this.assertNotMatch(spec, "/xyz123");
        this.assertNotMatch(spec, "/xyz123;jessionid=99");
        this.assertNotMatch(spec, "/xyz123/");
        this.assertNotMatch(spec, "/xyz123/456");
        this.assertNotMatch(spec, "/xyz.123");
        this.assertNotMatch(spec, "/xyz;123");
        this.assertNotMatch(spec, "/xyz?123");
    }

    @Test
    public void testPrecidenceVsOrdering() throws Exception {
        PathMap p = new PathMap();
        p.put("/dump/gzip/*", (Object)"prefix");
        p.put("*.txt", (Object)"suffix");
        Assert.assertEquals(null, (Object)p.getMatch("/foo/bar"));
        Assert.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something").getValue());
        Assert.assertEquals((Object)"suffix", (Object)p.getMatch("/foo/something.txt").getValue());
        Assert.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something.txt").getValue());
        p = new PathMap();
        p.put("*.txt", (Object)"suffix");
        p.put("/dump/gzip/*", (Object)"prefix");
        Assert.assertEquals(null, (Object)p.getMatch("/foo/bar"));
        Assert.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something").getValue());
        Assert.assertEquals((Object)"suffix", (Object)p.getMatch("/foo/something.txt").getValue());
        Assert.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something.txt").getValue());
    }

    private void assertMatch(String spec, String path) {
        boolean match = PathMap.match((String)spec, (String)path);
        Assert.assertTrue((String)("PathSpec '" + spec + "' should match path '" + path + "'"), (boolean)match);
    }

    private void assertNotMatch(String spec, String path) {
        boolean match = PathMap.match((String)spec, (String)path);
        Assert.assertFalse((String)("PathSpec '" + spec + "' should not match path '" + path + "'"), (boolean)match);
    }
}

