/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.MimeTypes;
import org.junit.Assert;
import org.junit.Test;

public class MimeTypesTest {
    @Test
    public void testGetMimeByExtension_Gzip() {
        this.assertMimeTypeByExtension("application/gzip", "test.gz");
    }

    @Test
    public void testGetMimeByExtension_Png() {
        this.assertMimeTypeByExtension("image/png", "test.png");
        this.assertMimeTypeByExtension("image/png", "TEST.PNG");
        this.assertMimeTypeByExtension("image/png", "Test.Png");
    }

    @Test
    public void testGetMimeByExtension_Png_MultiDot() {
        this.assertMimeTypeByExtension("image/png", "org.eclipse.jetty.Logo.png");
    }

    @Test
    public void testGetMimeByExtension_Png_DeepPath() {
        this.assertMimeTypeByExtension("image/png", "/org/eclipse/jetty/Logo.png");
    }

    @Test
    public void testGetMimeByExtension_Text() {
        this.assertMimeTypeByExtension("text/plain", "test.txt");
        this.assertMimeTypeByExtension("text/plain", "TEST.TXT");
    }

    @Test
    public void testGetMimeByExtension_NoExtension() {
        MimeTypes mimetypes = new MimeTypes();
        String contentType = mimetypes.getMimeByExtension("README");
        Assert.assertNull((Object)contentType);
    }

    private void assertMimeTypeByExtension(String expectedMimeType, String filename) {
        MimeTypes mimetypes = new MimeTypes();
        String contentType = mimetypes.getMimeByExtension(filename);
        String prefix = "MimeTypes.getMimeByExtension(" + filename + ")";
        Assert.assertNotNull((String)prefix, (Object)contentType);
        Assert.assertEquals((String)prefix, (Object)expectedMimeType, (Object)contentType);
    }

    @Test
    public void testCharsetFromContentType() {
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar;charset=abc;some=else"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar;charset=abc"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar ; charset = abc"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar ; charset = abc ; some=else"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar;other=param;charset=abc;some=else"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar;other=param;charset=abc"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar other = param ; charset = abc"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar other = param ; charset = abc ; some=else"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar other = param ; charset = abc"));
        Assert.assertEquals((Object)"abc", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar other = param ; charset = \"abc\" ; some=else"));
        Assert.assertEquals(null, (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar"));
        Assert.assertEquals((Object)"utf-8", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar;charset=uTf8"));
        Assert.assertEquals((Object)"utf-8", (Object)MimeTypes.getCharsetFromContentType((String)"foo/bar;other=\"charset=abc\";charset=uTf8"));
        Assert.assertEquals((Object)"utf-8", (Object)MimeTypes.getCharsetFromContentType((String)"text/html;charset=utf-8"));
    }

    @Test
    public void testContentTypeWithoutCharset() {
        Assert.assertEquals((Object)"foo/bar;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;charset=abc;some=else"));
        Assert.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;charset=abc"));
        Assert.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; charset = abc"));
        Assert.assertEquals((Object)"foo/bar;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; charset = abc ; some=else"));
        Assert.assertEquals((Object)"foo/bar;other=param;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;other=param;charset=abc;some=else"));
        Assert.assertEquals((Object)"foo/bar;other=param", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;other=param;charset=abc"));
        Assert.assertEquals((Object)"foo/bar ; other = param", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = abc"));
        Assert.assertEquals((Object)"foo/bar ; other = param;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = abc ; some=else"));
        Assert.assertEquals((Object)"foo/bar ; other = param", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = abc"));
        Assert.assertEquals((Object)"foo/bar ; other = param;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = \"abc\" ; some=else"));
        Assert.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar"));
        Assert.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;charset=uTf8"));
        Assert.assertEquals((Object)"foo/bar;other=\"charset=abc\"", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;other=\"charset=abc\";charset=uTf8"));
        Assert.assertEquals((Object)"text/html", (Object)MimeTypes.getContentTypeWithoutCharset((String)"text/html;charset=utf-8"));
    }
}

