/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpParserTest {
    private String _host;
    private int _port;
    private String _bad;
    private String _content;
    private String _methodOrVersion;
    private String _uriOrStatus;
    private String _versionOrReason;
    private List<HttpField> _fields = new ArrayList<HttpField>();
    private String[] _hdr;
    private String[] _val;
    private int _headers;
    private boolean _early;
    private boolean _headerCompleted;
    private boolean _messageCompleted;
    private String _complianceViolation;

    public static void parseAll(HttpParser parser, ByteBuffer buffer) {
        if (parser.isState(HttpParser.State.END)) {
            parser.reset();
        }
        if (!parser.isState(HttpParser.State.START)) {
            throw new IllegalStateException("!START");
        }
        int remaining = buffer.remaining();
        while (!parser.isState(HttpParser.State.END) && remaining > 0) {
            int was_remaining = remaining;
            parser.parseNext(buffer);
            remaining = buffer.remaining();
            if (remaining != was_remaining) continue;
            break;
        }
    }

    @Test
    public void HttpMethodTest() {
        Assert.assertNull((Object)HttpMethod.lookAheadGet((ByteBuffer)BufferUtil.toBuffer((String)"Wibble ")));
        Assert.assertNull((Object)HttpMethod.lookAheadGet((ByteBuffer)BufferUtil.toBuffer((String)"GET")));
        Assert.assertNull((Object)HttpMethod.lookAheadGet((ByteBuffer)BufferUtil.toBuffer((String)"MO")));
        Assert.assertEquals((Object)HttpMethod.GET, (Object)HttpMethod.lookAheadGet((ByteBuffer)BufferUtil.toBuffer((String)"GET ")));
        Assert.assertEquals((Object)HttpMethod.MOVE, (Object)HttpMethod.lookAheadGet((ByteBuffer)BufferUtil.toBuffer((String)"MOVE ")));
        ByteBuffer b = BufferUtil.allocateDirect((int)128);
        BufferUtil.append((ByteBuffer)b, (ByteBuffer)BufferUtil.toBuffer((String)"GET"));
        Assert.assertNull((Object)HttpMethod.lookAheadGet((ByteBuffer)b));
        BufferUtil.append((ByteBuffer)b, (ByteBuffer)BufferUtil.toBuffer((String)" "));
        Assert.assertEquals((Object)HttpMethod.GET, (Object)HttpMethod.lookAheadGet((ByteBuffer)b));
    }

    @Test
    public void testLineParse_Mock_IP() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /mock/127.0.0.1 HTTP/1.1\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/mock/127.0.0.1", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
    }

    @Test
    public void testLineParse0() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /foo HTTP/1.0\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/foo", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
    }

    @Test
    public void testLineParse1_RFC2616() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET /999\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, HttpCompliance.RFC2616);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertNull((Object)this._bad);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/999", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/0.9", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
        Assert.assertThat((Object)this._complianceViolation, (Matcher)Matchers.containsString((String)"0.9"));
    }

    @Test
    public void testLineParse1() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET /999\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"HTTP/0.9 not supported", (Object)this._bad);
        Assert.assertNull((Object)this._complianceViolation);
    }

    @Test
    public void testLineParse2_RFC2616() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /222  \r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, HttpCompliance.RFC2616);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertNull((Object)this._bad);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/222", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/0.9", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
        Assert.assertThat((Object)this._complianceViolation, (Matcher)Matchers.containsString((String)"0.9"));
    }

    @Test
    public void testLineParse2() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /222  \r\n");
        this._versionOrReason = null;
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"HTTP/0.9 not supported", (Object)this._bad);
        Assert.assertNull((Object)this._complianceViolation);
    }

    @Test
    public void testLineParse3() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /fo\u0690 HTTP/1.0\r\n\r\n", (Charset)StandardCharsets.UTF_8);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/fo\u0690", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
    }

    @Test
    public void testLineParse4() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /foo?param=\u0690 HTTP/1.0\r\n\r\n", (Charset)StandardCharsets.UTF_8);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/foo?param=\u0690", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
    }

    @Test
    public void testLongURLParse() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/ HTTP/1.0\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/123456789abcdef/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
    }

    @Test
    public void testConnect() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"CONNECT 192.168.1.2:80 HTTP/1.1\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"CONNECT", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"192.168.1.2:80", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
    }

    @Test
    public void testSimple() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Connection", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"close", (Object)this._val[1]);
        Assert.assertEquals((long)1L, (long)this._headers);
    }

    @Test
    public void testFoldedField2616() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nName: value\r\n extra\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, HttpCompliance.RFC2616);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.nullValue());
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Name", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value extra", (Object)this._val[1]);
        Assert.assertEquals((long)1L, (long)this._headers);
        Assert.assertThat((Object)this._complianceViolation, (Matcher)Matchers.containsString((String)"folding"));
    }

    @Test
    public void testFoldedField7230() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nName: value\r\n extra\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, 4096, HttpCompliance.RFC7230);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.containsString((String)"Header Folding"));
        Assert.assertNull((Object)this._complianceViolation);
    }

    @Test
    public void testWhiteSpaceInName() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nN ame: value\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, 4096, HttpCompliance.RFC7230);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.containsString((String)"Illegal character"));
    }

    @Test
    public void testWhiteSpaceAfterName() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nName : value\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, 4096, HttpCompliance.RFC7230);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.containsString((String)"Illegal character"));
    }

    @Test
    public void testNoValue() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nName0: \r\nName1:\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Name0", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"", (Object)this._val[1]);
        Assert.assertEquals((Object)"Name1", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"", (Object)this._val[2]);
        Assert.assertEquals((long)2L, (long)this._headers);
    }

    @Test
    public void testNoColon2616() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nName\r\nOther: value\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, HttpCompliance.RFC2616);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Name", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"", (Object)this._val[1]);
        Assert.assertEquals((Object)"Other", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"value", (Object)this._val[2]);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertThat((Object)this._complianceViolation, (Matcher)Matchers.containsString((String)"name only"));
    }

    @Test
    public void testNoColon7230() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nName\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, HttpCompliance.RFC7230);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.containsString((String)"Illegal character"));
        Assert.assertNull((Object)this._complianceViolation);
    }

    @Test
    public void testHeaderParseDirect() throws Exception {
        ByteBuffer b0 = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nHeader1: value1\r\nHeader2:   value 2a  \r\nHeader3: 3\r\nHeader4:value4\r\nServer5: notServer\r\nHostHeader: notHost\r\nConnection: close\r\nAccept-Encoding: gzip, deflated\r\nAccept: unknown\r\n\r\n");
        ByteBuffer buffer = BufferUtil.allocateDirect((int)b0.capacity());
        int pos = BufferUtil.flipToFill((ByteBuffer)buffer);
        BufferUtil.put((ByteBuffer)b0, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value1", (Object)this._val[1]);
        Assert.assertEquals((Object)"Header2", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"value 2a", (Object)this._val[2]);
        Assert.assertEquals((Object)"Header3", (Object)this._hdr[3]);
        Assert.assertEquals((Object)"3", (Object)this._val[3]);
        Assert.assertEquals((Object)"Header4", (Object)this._hdr[4]);
        Assert.assertEquals((Object)"value4", (Object)this._val[4]);
        Assert.assertEquals((Object)"Server5", (Object)this._hdr[5]);
        Assert.assertEquals((Object)"notServer", (Object)this._val[5]);
        Assert.assertEquals((Object)"HostHeader", (Object)this._hdr[6]);
        Assert.assertEquals((Object)"notHost", (Object)this._val[6]);
        Assert.assertEquals((Object)"Connection", (Object)this._hdr[7]);
        Assert.assertEquals((Object)"close", (Object)this._val[7]);
        Assert.assertEquals((Object)"Accept-Encoding", (Object)this._hdr[8]);
        Assert.assertEquals((Object)"gzip, deflated", (Object)this._val[8]);
        Assert.assertEquals((Object)"Accept", (Object)this._hdr[9]);
        Assert.assertEquals((Object)"unknown", (Object)this._val[9]);
        Assert.assertEquals((long)9L, (long)this._headers);
    }

    @Test
    public void testHeaderParseCRLF() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nHost: localhost\r\nHeader1: value1\r\nHeader2:   value 2a  \r\nHeader3: 3\r\nHeader4:value4\r\nServer5: notServer\r\nHostHeader: notHost\r\nConnection: close\r\nAccept-Encoding: gzip, deflated\r\nAccept: unknown\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value1", (Object)this._val[1]);
        Assert.assertEquals((Object)"Header2", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"value 2a", (Object)this._val[2]);
        Assert.assertEquals((Object)"Header3", (Object)this._hdr[3]);
        Assert.assertEquals((Object)"3", (Object)this._val[3]);
        Assert.assertEquals((Object)"Header4", (Object)this._hdr[4]);
        Assert.assertEquals((Object)"value4", (Object)this._val[4]);
        Assert.assertEquals((Object)"Server5", (Object)this._hdr[5]);
        Assert.assertEquals((Object)"notServer", (Object)this._val[5]);
        Assert.assertEquals((Object)"HostHeader", (Object)this._hdr[6]);
        Assert.assertEquals((Object)"notHost", (Object)this._val[6]);
        Assert.assertEquals((Object)"Connection", (Object)this._hdr[7]);
        Assert.assertEquals((Object)"close", (Object)this._val[7]);
        Assert.assertEquals((Object)"Accept-Encoding", (Object)this._hdr[8]);
        Assert.assertEquals((Object)"gzip, deflated", (Object)this._val[8]);
        Assert.assertEquals((Object)"Accept", (Object)this._hdr[9]);
        Assert.assertEquals((Object)"unknown", (Object)this._val[9]);
        Assert.assertEquals((long)9L, (long)this._headers);
    }

    @Test
    public void testHeaderParseLF() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\nHost: localhost\nHeader1: value1\nHeader2:   value 2a value 2b  \nHeader3: 3\nHeader4:value4\nServer5: notServer\nHostHeader: notHost\nConnection: close\nAccept-Encoding: gzip, deflated\nAccept: unknown\n\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value1", (Object)this._val[1]);
        Assert.assertEquals((Object)"Header2", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"value 2a value 2b", (Object)this._val[2]);
        Assert.assertEquals((Object)"Header3", (Object)this._hdr[3]);
        Assert.assertEquals((Object)"3", (Object)this._val[3]);
        Assert.assertEquals((Object)"Header4", (Object)this._hdr[4]);
        Assert.assertEquals((Object)"value4", (Object)this._val[4]);
        Assert.assertEquals((Object)"Server5", (Object)this._hdr[5]);
        Assert.assertEquals((Object)"notServer", (Object)this._val[5]);
        Assert.assertEquals((Object)"HostHeader", (Object)this._hdr[6]);
        Assert.assertEquals((Object)"notHost", (Object)this._val[6]);
        Assert.assertEquals((Object)"Connection", (Object)this._hdr[7]);
        Assert.assertEquals((Object)"close", (Object)this._val[7]);
        Assert.assertEquals((Object)"Accept-Encoding", (Object)this._hdr[8]);
        Assert.assertEquals((Object)"gzip, deflated", (Object)this._val[8]);
        Assert.assertEquals((Object)"Accept", (Object)this._hdr[9]);
        Assert.assertEquals((Object)"unknown", (Object)this._val[9]);
        Assert.assertEquals((long)9L, (long)this._headers);
    }

    @Test
    public void testQuoted() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\nName0: \"value0\"\t\nName1: \"value\t1\"\nName2: \"value\t2A\",\"value,2B\"\t\n\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Name0", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"\"value0\"", (Object)this._val[0]);
        Assert.assertEquals((Object)"Name1", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"\"value\t1\"", (Object)this._val[1]);
        Assert.assertEquals((Object)"Name2", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"\"value\t2A\",\"value,2B\"", (Object)this._val[2]);
        Assert.assertEquals((long)2L, (long)this._headers);
    }

    @Test
    public void testEncodedHeader() throws Exception {
        ByteBuffer buffer = BufferUtil.allocate((int)4096);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        BufferUtil.put((ByteBuffer)BufferUtil.toBuffer((String)"GET "), (ByteBuffer)buffer);
        buffer.put("/foo/\u0690/".getBytes(StandardCharsets.UTF_8));
        BufferUtil.put((ByteBuffer)BufferUtil.toBuffer((String)" HTTP/1.0\r\n"), (ByteBuffer)buffer);
        BufferUtil.put((ByteBuffer)BufferUtil.toBuffer((String)"Header1: "), (ByteBuffer)buffer);
        buffer.put("\u00e6 \u00e6".getBytes(StandardCharsets.ISO_8859_1));
        BufferUtil.put((ByteBuffer)BufferUtil.toBuffer((String)"  \r\n\r\n"), (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/foo/\u0690/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"\u00e6 \u00e6", (Object)this._val[0]);
        Assert.assertEquals((long)0L, (long)this._headers);
        Assert.assertEquals(null, (Object)this._bad);
    }

    @Test
    public void testBadMethodEncoding() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"G\u00e6T / HTTP/1.0\r\nHeader0: value0\r\n\n\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadVersionEncoding() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / H\u00e6P/1.0\r\nHeader0: value0\r\n\n\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadHeaderEncoding() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nH\u00e6der0: value0\r\n\n\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testHeaderTab() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: localhost\r\nHeader: value\talternate\r\n\n\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Header", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value\talternate", (Object)this._val[1]);
    }

    @Test
    public void testCaseInsensitive() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"get / http/1.0\r\nHOST: localhost\r\ncOnNeCtIoN: ClOsE\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, -1, HttpCompliance.RFC7230);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertNull((Object)this._bad);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Connection", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"close", (Object)this._val[1]);
        Assert.assertEquals((long)1L, (long)this._headers);
        Assert.assertNull((Object)this._complianceViolation);
    }

    @Test
    public void testCaseSensitiveLegacy() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"gEt / http/1.0\r\nHOST: localhost\r\ncOnNeCtIoN: ClOsE\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler, -1, HttpCompliance.LEGACY);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertNull((Object)this._bad);
        Assert.assertEquals((Object)"gEt", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"HOST", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"cOnNeCtIoN", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"ClOsE", (Object)this._val[1]);
        Assert.assertEquals((long)1L, (long)this._headers);
        Assert.assertThat((Object)this._complianceViolation, (Matcher)Matchers.containsString((String)"case sensitive"));
    }

    @Test
    public void testSplitHeaderParse() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"XXXXSPLIT / HTTP/1.0\r\nHost: localhost\r\nHeader1: value1\r\nHeader2:   value 2a  \r\nHeader3: 3\r\nHeader4:value4\r\nServer5: notServer\r\n\r\nZZZZ");
        buffer.position(2);
        buffer.limit(buffer.capacity() - 2);
        buffer = buffer.slice();
        for (int i = 0; i < buffer.capacity() - 4; ++i) {
            Handler handler = new Handler();
            HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
            buffer.position(2);
            buffer.limit(2 + i);
            if (!parser.parseNext(buffer)) {
                Assert.assertEquals((long)0L, (long)buffer.remaining());
                buffer.limit(buffer.capacity() - 2);
                parser.parseNext(buffer);
            }
            Assert.assertEquals((Object)"SPLIT", (Object)this._methodOrVersion);
            Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
            Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
            Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
            Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
            Assert.assertEquals((Object)"Header1", (Object)this._hdr[1]);
            Assert.assertEquals((Object)"value1", (Object)this._val[1]);
            Assert.assertEquals((Object)"Header2", (Object)this._hdr[2]);
            Assert.assertEquals((Object)"value 2a", (Object)this._val[2]);
            Assert.assertEquals((Object)"Header3", (Object)this._hdr[3]);
            Assert.assertEquals((Object)"3", (Object)this._val[3]);
            Assert.assertEquals((Object)"Header4", (Object)this._hdr[4]);
            Assert.assertEquals((Object)"value4", (Object)this._val[4]);
            Assert.assertEquals((Object)"Server5", (Object)this._hdr[5]);
            Assert.assertEquals((Object)"notServer", (Object)this._val[5]);
            Assert.assertEquals((long)5L, (long)this._headers);
        }
    }

    @Test
    public void testChunkParse() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET /chunk HTTP/1.0\r\nHeader1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n1a\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/chunk", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)1L, (long)this._headers);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"value1", (Object)this._val[0]);
        Assert.assertEquals((Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testStartEOF() throws Exception {
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertTrue((boolean)this._early);
        Assert.assertEquals(null, (Object)this._bad);
    }

    @Test
    public void testEarlyEOF() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET /uri HTTP/1.0\r\nContent-Length: 20\r\n\r\n0123456789");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.atEOF();
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/uri", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"0123456789", (Object)this._content);
        Assert.assertTrue((boolean)this._early);
    }

    @Test
    public void testChunkEarlyEOF() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET /chunk HTTP/1.0\r\nHeader1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.atEOF();
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/chunk", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)1L, (long)this._headers);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"value1", (Object)this._val[0]);
        Assert.assertEquals((Object)"0123456789", (Object)this._content);
        Assert.assertTrue((boolean)this._early);
    }

    @Test
    public void testMultiParse() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET /mp HTTP/1.0\r\nConnection: Keep-Alive\r\nHeader1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n1a\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0\r\n\r\nPOST /foo HTTP/1.0\r\nConnection: Keep-Alive\r\nHeader2: value2\r\nContent-Length: 0\r\n\r\nPUT /doodle HTTP/1.0\r\nConnection: close\r\nHeader3: value3\r\nContent-Length: 10\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/mp", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value1", (Object)this._val[1]);
        Assert.assertEquals((Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)this._content);
        parser.reset();
        this.init();
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/foo", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertEquals((Object)"Header2", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value2", (Object)this._val[1]);
        Assert.assertEquals(null, (Object)this._content);
        parser.reset();
        this.init();
        parser.parseNext(buffer);
        parser.atEOF();
        Assert.assertEquals((Object)"PUT", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/doodle", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertEquals((Object)"Header3", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value3", (Object)this._val[1]);
        Assert.assertEquals((Object)"0123456789", (Object)this._content);
    }

    @Test
    public void testMultiParseEarlyEOF() throws Exception {
        ByteBuffer buffer0 = BufferUtil.toBuffer((String)"GET /mp HTTP/1.0\r\nConnection: Keep-Alive\r\n");
        ByteBuffer buffer1 = BufferUtil.toBuffer((String)"Header1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n1a\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0\r\n\r\nPOST /foo HTTP/1.0\r\nConnection: Keep-Alive\r\nHeader2: value2\r\nContent-Length: 0\r\n\r\nPUT /doodle HTTP/1.0\r\nConnection: close\r\nHeader3: value3\r\nContent-Length: 10\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer0);
        parser.atEOF();
        parser.parseNext(buffer1);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/mp", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertEquals((Object)"Header1", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value1", (Object)this._val[1]);
        Assert.assertEquals((Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)this._content);
        parser.reset();
        this.init();
        parser.parseNext(buffer1);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/foo", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertEquals((Object)"Header2", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value2", (Object)this._val[1]);
        Assert.assertEquals(null, (Object)this._content);
        parser.reset();
        this.init();
        parser.parseNext(buffer1);
        Assert.assertEquals((Object)"PUT", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/doodle", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)2L, (long)this._headers);
        Assert.assertEquals((Object)"Header3", (Object)this._hdr[1]);
        Assert.assertEquals((Object)"value3", (Object)this._val[1]);
        Assert.assertEquals((Object)"0123456789", (Object)this._content);
    }

    @Test
    public void testResponseParse0() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 200 Correct\r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"200", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"Correct", (Object)this._versionOrReason);
        Assert.assertEquals((long)10L, (long)this._content.length());
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponseParse1() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 304 Not-Modified\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"304", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"Not-Modified", (Object)this._versionOrReason);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponseParse2() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 204 No-Content\r\nHeader: value\r\n\r\nHTTP/1.1 200 Correct\r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"204", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"No-Content", (Object)this._versionOrReason);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
        parser.reset();
        this.init();
        parser.parseNext(buffer);
        parser.atEOF();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"200", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"Correct", (Object)this._versionOrReason);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponseParse3() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 200\r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"200", (Object)this._uriOrStatus);
        Assert.assertEquals(null, (Object)this._versionOrReason);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponseParse4() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 200 \r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"200", (Object)this._uriOrStatus);
        Assert.assertEquals(null, (Object)this._versionOrReason);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponseEOFContent() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 200 \r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.atEOF();
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"200", (Object)this._uriOrStatus);
        Assert.assertEquals(null, (Object)this._versionOrReason);
        Assert.assertEquals((long)12L, (long)this._content.length());
        Assert.assertEquals((Object)"0123456789\r\n", (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponse304WithContentLength() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 304 found\r\nContent-Length: 10\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"304", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"found", (Object)this._versionOrReason);
        Assert.assertEquals(null, (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testResponse101WithTransferEncoding() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 101 switching protocols\r\nTransfer-Encoding: chunked\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"101", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"switching protocols", (Object)this._versionOrReason);
        Assert.assertEquals(null, (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testSeekEOF() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 0\r\nConnection: close\r\n\r\n\r\nHTTP/1.1 400 OK\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"200", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"OK", (Object)this._versionOrReason);
        Assert.assertEquals(null, (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
        parser.close();
        parser.reset();
        parser.parseNext(buffer);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testNoURI() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET\r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"No URI", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testNoURI2() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET \r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"No URI", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testUnknownReponseVersion() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HPPT/7.7 200 OK\r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Unknown Version", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testNoStatus() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1\r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"No Status", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testNoStatus2() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"HTTP/1.1 \r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"No Status", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testBadRequestVersion() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HPPT/7.7\r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Unknown Version", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
        buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.01\r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
        handler = new Handler();
        parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Unknown Version", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testBadCR() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nContent-Length: 0\rConnection: close\r\r");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"Bad EOL", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
        buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\rContent-Length: 0\rConnection: close\r\r");
        handler = new Handler();
        parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"Bad EOL", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testBadContentLength0() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nContent-Length: abc\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Invalid Content-Length Value", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testBadContentLength1() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nContent-Length: 9999999999999999999999999999999999999999999999\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Invalid Content-Length Value", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testBadContentLength2() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.0\r\nContent-Length: 1.5\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Invalid Content-Length Value", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testDuplicateContentLengthWithLargerThenCorrectValue() {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST / HTTP/1.1\r\nContent-Length: 2\r\nContent-Length: 1\r\nConnection: close\r\n\r\nX");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Duplicate Content-Length", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testDuplicateContentLengthWithCorrectThenLargerValue() {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST / HTTP/1.1\r\nContent-Length: 1\r\nContent-Length: 2\r\nConnection: close\r\n\r\nX");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"Duplicate Content-Length", (Object)this._bad);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertEquals((Object)HttpParser.State.CLOSE, (Object)parser.getState());
        parser.atEOF();
        parser.parseNext(BufferUtil.EMPTY_BUFFER);
        Assert.assertEquals((Object)HttpParser.State.CLOSED, (Object)parser.getState());
    }

    @Test
    public void testTransferEncodingChunkedThenContentLength() {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /chunk HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\nContent-Length: 1\r\n\r\n1\r\nX\r\n0\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/chunk", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"X", (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testContentLengthThenTransferEncodingChunked() {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"POST /chunk HTTP/1.1\r\nHost: localhost\r\nContent-Length: 1\r\nTransfer-Encoding: chunked\r\n\r\n1\r\nX\r\n0\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"POST", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/chunk", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"X", (Object)this._content);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
    }

    @Test
    public void testHost() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: host\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"host", (Object)this._host);
        Assert.assertEquals((long)0L, (long)this._port);
    }

    @Test
    public void testUriHost11() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET http://host/ HTTP/1.1\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"No Host", (Object)this._bad);
        Assert.assertEquals((Object)"http://host/", (Object)this._uriOrStatus);
        Assert.assertEquals((long)0L, (long)this._port);
    }

    @Test
    public void testUriHost10() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET http://host/ HTTP/1.0\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertNull((Object)this._bad);
        Assert.assertEquals((Object)"http://host/", (Object)this._uriOrStatus);
        Assert.assertEquals((long)0L, (long)this._port);
    }

    @Test
    public void testNoHost() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"No Host", (Object)this._bad);
    }

    @Test
    public void testIPHost() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"192.168.0.1", (Object)this._host);
        Assert.assertEquals((long)0L, (long)this._port);
    }

    @Test
    public void testIPv6Host() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: [::1]\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"[::1]", (Object)this._host);
        Assert.assertEquals((long)0L, (long)this._port);
    }

    @Test
    public void testBadIPv6Host() throws Exception {
        try (StacklessLogging s = new StacklessLogging(new Class[]{HttpParser.class});){
            ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: [::1\r\nConnection: close\r\n\r\n");
            Handler handler = new Handler();
            HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
            parser.parseNext(buffer);
            Assert.assertThat((Object)this._bad, (Matcher)Matchers.containsString((String)"Bad"));
        }
    }

    @Test
    public void testHostPort() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: myhost:8888\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"myhost", (Object)this._host);
        Assert.assertEquals((long)8888L, (long)this._port);
    }

    @Test
    public void testHostBadPort() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: myhost:testBadPort\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertThat((Object)this._bad, (Matcher)Matchers.containsString((String)"Bad Host"));
    }

    @Test
    public void testIPHostPort() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: 192.168.0.1:8888\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"192.168.0.1", (Object)this._host);
        Assert.assertEquals((long)8888L, (long)this._port);
    }

    @Test
    public void testIPv6HostPort() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: [::1]:8888\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"[::1]", (Object)this._host);
        Assert.assertEquals((long)8888L, (long)this._port);
    }

    @Test
    public void testEmptyHostPort() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost:\r\nConnection: close\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals(null, (Object)this._host);
        Assert.assertEquals(null, (Object)this._bad);
    }

    @Test
    public void testCachedField() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: www.smh.com.au\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertEquals((Object)"www.smh.com.au", (Object)((HttpField)parser.getFieldCache().get("Host: www.smh.com.au")).getValue());
        HttpField field = this._fields.get(0);
        buffer.position(0);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertTrue((field == this._fields.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void testParseRequest() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: localhost\r\nHeader1: value1\r\nConnection: close\r\nAccept-Encoding: gzip, deflated\r\nAccept: unknown\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        parser.parseNext(buffer);
        Assert.assertEquals((Object)"GET", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"/", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this._versionOrReason);
        Assert.assertEquals((Object)"Host", (Object)this._hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this._val[0]);
        Assert.assertEquals((Object)"Connection", (Object)this._hdr[2]);
        Assert.assertEquals((Object)"close", (Object)this._val[2]);
        Assert.assertEquals((Object)"Accept-Encoding", (Object)this._hdr[3]);
        Assert.assertEquals((Object)"gzip, deflated", (Object)this._val[3]);
        Assert.assertEquals((Object)"Accept", (Object)this._hdr[4]);
        Assert.assertEquals((Object)"unknown", (Object)this._val[4]);
    }

    @Test
    public void testHTTP2Preface() throws Exception {
        ByteBuffer buffer = BufferUtil.toBuffer((String)"PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)handler);
        HttpParserTest.parseAll(parser, buffer);
        Assert.assertTrue((boolean)this._headerCompleted);
        Assert.assertTrue((boolean)this._messageCompleted);
        Assert.assertEquals((Object)"PRI", (Object)this._methodOrVersion);
        Assert.assertEquals((Object)"*", (Object)this._uriOrStatus);
        Assert.assertEquals((Object)"HTTP/2.0", (Object)this._versionOrReason);
        Assert.assertEquals((long)-1L, (long)this._headers);
        Assert.assertEquals(null, (Object)this._bad);
    }

    @Before
    public void init() {
        this._bad = null;
        this._content = null;
        this._methodOrVersion = null;
        this._uriOrStatus = null;
        this._versionOrReason = null;
        this._hdr = null;
        this._val = null;
        this._headers = 0;
        this._headerCompleted = false;
        this._messageCompleted = false;
        this._complianceViolation = null;
    }

    static /* synthetic */ String[] access$402(HttpParserTest x0, String[] x1) {
        x0._hdr = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(HttpParserTest x0, String[] x1) {
        x0._val = x1;
        return x1;
    }

    private class Handler
    implements HttpParser.RequestHandler,
    HttpParser.ResponseHandler,
    HttpParser.ComplianceHandler {
        private HttpFields fields;

        private Handler() {
        }

        public boolean content(ByteBuffer ref) {
            if (HttpParserTest.this._content == null) {
                HttpParserTest.this._content = "";
            }
            String c = BufferUtil.toString((ByteBuffer)ref, (Charset)StandardCharsets.UTF_8);
            HttpParserTest.this._content = HttpParserTest.this._content + c;
            ref.position(ref.limit());
            return false;
        }

        public boolean startRequest(String method, String uri, HttpVersion version) {
            HttpParserTest.this._fields.clear();
            HttpParserTest.this._headers = -1;
            HttpParserTest.access$402(HttpParserTest.this, new String[10]);
            HttpParserTest.access$502(HttpParserTest.this, new String[10]);
            HttpParserTest.this._methodOrVersion = method;
            HttpParserTest.this._uriOrStatus = uri;
            HttpParserTest.this._versionOrReason = version == null ? null : version.asString();
            this.fields = new HttpFields();
            HttpParserTest.this._messageCompleted = false;
            HttpParserTest.this._headerCompleted = false;
            HttpParserTest.this._early = false;
            return false;
        }

        public void parsedHeader(HttpField field) {
            HttpParserTest.this._fields.add(field);
            ((HttpParserTest)HttpParserTest.this)._hdr[++((HttpParserTest)HttpParserTest.this)._headers] = field.getName();
            ((HttpParserTest)HttpParserTest.this)._val[((HttpParserTest)HttpParserTest.this)._headers] = field.getValue();
            if (field instanceof HostPortHttpField) {
                HostPortHttpField hpfield = (HostPortHttpField)field;
                HttpParserTest.this._host = hpfield.getHost();
                HttpParserTest.this._port = hpfield.getPort();
            }
        }

        public boolean headerComplete() {
            HttpParserTest.this._content = null;
            String s0 = this.fields.toString();
            String s1 = this.fields.toString();
            if (!s0.equals(s1)) {
                throw new IllegalStateException();
            }
            HttpParserTest.this._headerCompleted = true;
            return false;
        }

        public boolean messageComplete() {
            HttpParserTest.this._messageCompleted = true;
            return true;
        }

        public void badMessage(int status, String reason) {
            HttpParserTest.this._bad = reason == null ? "" + status : reason;
        }

        public boolean startResponse(HttpVersion version, int status, String reason) {
            HttpParserTest.this._fields.clear();
            HttpParserTest.this._methodOrVersion = version.asString();
            HttpParserTest.this._uriOrStatus = Integer.toString(status);
            HttpParserTest.this._versionOrReason = reason;
            this.fields = new HttpFields();
            HttpParserTest.access$402(HttpParserTest.this, new String[9]);
            HttpParserTest.access$502(HttpParserTest.this, new String[9]);
            HttpParserTest.this._messageCompleted = false;
            HttpParserTest.this._headerCompleted = false;
            return false;
        }

        public void earlyEOF() {
            HttpParserTest.this._early = true;
        }

        public int getHeaderCacheSize() {
            return 512;
        }

        public void onComplianceViolation(HttpCompliance compliance, HttpCompliance required, String reason) {
            HttpParserTest.this._complianceViolation = reason;
        }
    }
}

