/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.siwe.internal;

import java.security.Principal;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;

public class AnyUserLoginService
implements LoginService {
    private final String _realm;
    private final LoginService _loginService;
    private IdentityService _identityService;

    public AnyUserLoginService(String realm, LoginService loginService) {
        this._realm = realm;
        this._loginService = loginService;
        this._identityService = loginService == null ? new DefaultIdentityService() : null;
    }

    public String getName() {
        return this._realm;
    }

    public UserIdentity login(String username, Object credentials, Request request, Function<Boolean, Session> getOrCreateSession) {
        if (this._loginService != null) {
            UserIdentity login = this._loginService.login(username, credentials, request, getOrCreateSession);
            if (login != null) {
                return login;
            }
            UserPrincipal userPrincipal = new UserPrincipal(username, null);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)userPrincipal);
            if (credentials != null) {
                subject.getPrivateCredentials().add(credentials);
            }
            subject.setReadOnly();
            return this._loginService.getUserIdentity(subject, (Principal)userPrincipal, true);
        }
        UserPrincipal userPrincipal = new UserPrincipal(username, null);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)userPrincipal);
        if (credentials != null) {
            subject.getPrivateCredentials().add(credentials);
        }
        subject.setReadOnly();
        return this._identityService.newUserIdentity(subject, (Principal)userPrincipal, new String[0]);
    }

    public boolean validate(UserIdentity user) {
        if (this._loginService == null) {
            return user != null;
        }
        return this._loginService.validate(user);
    }

    public IdentityService getIdentityService() {
        return this._loginService == null ? this._identityService : this._loginService.getIdentityService();
    }

    public void setIdentityService(IdentityService service) {
        if (this._loginService != null) {
            this._loginService.setIdentityService(service);
        } else {
            this._identityService = service;
        }
    }

    public void logout(UserIdentity user) {
        if (this._loginService != null) {
            this._loginService.logout(user);
        }
    }
}

