/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ManyServletContexts {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        root.addServlet(new ServletHolder((Servlet)new HelloServlet("Ciao")), "/*");
        ServletContextHandler other = new ServletContextHandler((HandlerContainer)contexts, "/other", 1);
        other.addServlet("org.eclipse.jetty.server.example.ManyServletServletContextHandlers$HelloServlet", "/*");
        StatisticsHandler stats = new StatisticsHandler();
        contexts.addHandler((Handler)stats);
        ServletContextHandler yetanother = new ServletContextHandler((HandlerContainer)stats, "/yo", 1);
        yetanother.addServlet(new ServletHolder((Servlet)new HelloServlet("YO!")), "/*");
        server.start();
        server.join();
    }

    public static class HelloServlet
    extends HttpServlet {
        String greeting = "Hello";

        public HelloServlet() {
        }

        public HelloServlet(String hi) {
            this.greeting = hi;
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            response.setStatus(200);
            response.getWriter().println("<h1>" + this.greeting + " SimpleServlet</h1>");
            response.getWriter().println("session=" + request.getSession(true).getId());
        }
    }
}

