/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

public class ManyContexts {
    public static void main(String[] args) throws Exception {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(8080);
        server.setConnectors(new Connector[]{connector});
        ContextHandler context0 = new ContextHandler();
        context0.setContextPath("/");
        HelloHandler handler0 = new HelloHandler("Root Context");
        context0.setHandler((Handler)handler0);
        ContextHandler context1 = new ContextHandler();
        context1.setContextPath("/context");
        HelloHandler handler1 = new HelloHandler("A Context");
        context1.setHandler((Handler)handler1);
        ContextHandler context2 = new ContextHandler();
        context2.setContextPath("/context");
        context2.setVirtualHosts(new String[]{"127.0.0.2"});
        HelloHandler handler2 = new HelloHandler("A Virtual Context");
        context2.setHandler((Handler)handler2);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{context0, context1, context2});
        server.setHandler((Handler)contexts);
        server.start();
        server.join();
    }

    public static class HelloHandler
    extends AbstractHandler {
        String _welcome;

        HelloHandler(String welcome) {
            this._welcome = welcome;
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            response.setStatus(200);
            response.setContentType("text/html");
            response.getWriter().println("<h1>" + this._welcome + " " + request.getContextPath() + "</h1>");
            response.getWriter().println("<a href='/'>root context</a><br/>");
            response.getWriter().println("<a href='http://127.0.0.1:8080/context'>normal context</a><br/>");
            response.getWriter().println("<a href='http://127.0.0.2:8080/context'>virtual context</a><br/>");
        }
    }
}

