/*
 * Decompiled with CFR 0.152.
 */
package embedded.client.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RoundRobinConnectionPool;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.client.http.HttpClientConnectionFactory;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.AsyncRequestContent;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.BytesRequestContent;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.OutputStreamRequestContent;
import org.eclipse.jetty.client.util.PathRequestContent;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.fcgi.client.http.HttpClientTransportOverFCGI;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.ClientConnectionFactoryOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTPClientDocs {
    public void start() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.setFollowRedirects(false);
        httpClient.start();
    }

    public void stop() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.stop();
    }

    public void tlsExplicit() throws Exception {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        httpClient.start();
    }

    public void tlsNoValidation() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setEndpointIdentificationAlgorithm(null);
    }

    public void tlsAppValidation() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setHostnameVerifier((hostName, session) -> hostName.endsWith(".domain.com"));
    }

    public void simpleBlockingGet() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.GET("http://domain.com/path?query");
    }

    public void headFluent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.newRequest("http://domain.com/path?query").method(HttpMethod.HEAD).agent("Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:17.0) Gecko/20100101 Firefox/17.0").send();
    }

    public void headNonFluent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        Request request = httpClient.newRequest("http://domain.com/path?query");
        request.method(HttpMethod.HEAD);
        request.agent("Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:17.0) Gecko/20100101 Firefox/17.0");
        ContentResponse response = request.send();
    }

    public void postFluent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.POST("http://domain.com/entity/1").param("p", "value").send();
    }

    public void fileFluent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.POST("http://domain.com/upload").file(Paths.get("file_to_upload.txt", new String[0]), "text/plain").send();
    }

    public void totalTimeout() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.newRequest("http://domain.com/path?query").timeout(5L, TimeUnit.SECONDS).send();
    }

    public void simpleNonBlocking() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.newRequest("http://domain.com/path").send(result -> {});
    }

    public void nonBlockingTotalTimeout() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.newRequest("http://domain.com/path").timeout(3L, TimeUnit.SECONDS).send(result -> {});
    }

    public void listeners() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.newRequest("http://domain.com/path").onRequestQueued(request -> {}).onRequestBegin(request -> {}).onRequestHeaders(request -> {}).onRequestCommit(request -> {}).onRequestContent((request, content) -> {}).onRequestFailure((request, failure) -> {}).onRequestSuccess(request -> {}).onResponseBegin(response -> {}).onResponseHeader((response, field) -> true).onResponseHeaders(response -> {}).onResponseContentAsync((response, buffer, callback) -> callback.succeeded()).onResponseFailure((response, failure) -> {}).onResponseSuccess(response -> {}).send(result -> {});
    }

    public void pathRequestContent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.POST("http://domain.com/upload").body((Request.Content)new PathRequestContent("text/plain", Paths.get("file_to_upload.txt", new String[0]))).send();
    }

    public void inputStreamRequestContent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.POST("http://domain.com/upload").body((Request.Content)new InputStreamRequestContent("text/plain", (InputStream)new FileInputStream("file_to_upload.txt"))).send();
    }

    public void bytesStringRequestContent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        byte[] bytes = new byte[1024];
        String string = new String(bytes);
        ContentResponse bytesResponse = httpClient.POST("http://domain.com/upload").body((Request.Content)new BytesRequestContent("text/plain", (byte[][])new byte[][]{bytes})).send();
        ContentResponse stringResponse = httpClient.POST("http://domain.com/upload").body((Request.Content)new StringRequestContent("text/plain", string)).send();
    }

    public void asyncRequestContent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        AsyncRequestContent content = new AsyncRequestContent(new ByteBuffer[0]);
        httpClient.POST("http://domain.com/upload").body((Request.Content)content).send(result -> {});
    }

    public void outputStreamRequestContent() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        OutputStreamRequestContent content = new OutputStreamRequestContent();
        try (OutputStream output = content.getOutputStream();){
            httpClient.POST("http://localhost:8080/").body((Request.Content)content).send(result -> {});
            byte[] bytes = new byte[]{104, 101, 108, 108, 111};
            output.write(bytes);
        }
    }

    public void futureResponseListener() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        Request request = httpClient.newRequest("http://domain.com/path");
        FutureResponseListener listener = new FutureResponseListener(request, 524288);
        request.send((Response.CompleteListener)listener);
        ContentResponse response = listener.get(5L, TimeUnit.SECONDS);
    }

    public void bufferingResponseListener() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.newRequest("http://domain.com/path").send((Response.CompleteListener)new BufferingResponseListener(0x800000){

            public void onComplete(Result result) {
                if (!result.isFailed()) {
                    byte[] byArray = this.getContent();
                }
            }
        });
    }

    public void inputStreamResponseListener() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        InputStreamResponseListener listener = new InputStreamResponseListener();
        httpClient.newRequest("http://domain.com/path").send((Response.CompleteListener)listener);
        Response response = listener.get(5L, TimeUnit.SECONDS);
        if (response.getStatus() == 200) {
            InputStream responseContent = listener.getInputStream();
            if (responseContent != null) {
                responseContent.close();
            }
        } else {
            response.abort((Throwable)new IOException("Unexpected HTTP response"));
        }
    }

    public void demandedContentListener() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        String host1 = "localhost";
        String host2 = "localhost";
        int port1 = 8080;
        int port2 = 8080;
        Request request1 = httpClient.newRequest(host1, port1).path("/source");
        final AsyncRequestContent content2 = new AsyncRequestContent(new ByteBuffer[0]);
        final Request request2 = httpClient.newRequest(host2, port2).path("/sink").body((Request.Content)content2);
        request1.onResponseContentDemanded(new Response.DemandedContentListener(){

            public void onBeforeContent(Response response, LongConsumer demand) {
                request2.onRequestCommit(request -> demand.accept(1L));
                request2.send(result -> System.getLogger("forwarder").log(System.Logger.Level.INFO, "Forwarding to server2 complete"));
            }

            public void onContent(Response response, LongConsumer demand, ByteBuffer content, Callback callback) {
                content2.offer(content, Callback.from(() -> {
                    callback.succeeded();
                    demand.accept(1L);
                }, arg_0 -> ((Callback)callback).failed(arg_0)));
            }
        });
        request1.onResponseSuccess(response -> content2.close());
        request1.send(result -> System.getLogger("forwarder").log(System.Logger.Level.INFO, "Sourcing from server1 complete"));
    }

    public void getCookies() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        CookieStore cookieStore = httpClient.getCookieStore();
        List<HttpCookie> cookies = cookieStore.get(URI.create("http://domain.com/path"));
    }

    public void setCookie() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        CookieStore cookieStore = httpClient.getCookieStore();
        HttpCookie cookie = new HttpCookie("foo", "bar");
        cookie.setDomain("domain.com");
        cookie.setPath("/");
        cookie.setMaxAge(TimeUnit.DAYS.toSeconds(1L));
        cookieStore.add(URI.create("http://domain.com"), cookie);
    }

    public void requestCookie() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ContentResponse response = httpClient.newRequest("http://domain.com/path").cookie(new HttpCookie("foo", "bar")).send();
    }

    public void removeCookie() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        CookieStore cookieStore = httpClient.getCookieStore();
        URI uri = URI.create("http://domain.com");
        List<HttpCookie> cookies = cookieStore.get(uri);
        for (HttpCookie cookie : cookies) {
            cookieStore.remove(uri, cookie);
        }
    }

    public void emptyCookieStore() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
    }

    public void filteringCookieStore() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        class GoogleOnlyCookieStore
        extends HttpCookieStore {
            GoogleOnlyCookieStore() {
            }

            public void add(URI uri, HttpCookie cookie) {
                if (uri.getHost().endsWith("google.com")) {
                    super.add(uri, cookie);
                }
            }
        }
        httpClient.setCookieStore((CookieStore)((Object)new GoogleOnlyCookieStore()));
    }

    public void addAuthentication() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        AuthenticationStore auth = httpClient.getAuthenticationStore();
        URI uri1 = new URI("http://mydomain.com/secure");
        auth.addAuthentication((Authentication)new BasicAuthentication(uri1, "MyRealm", "userName1", "password1"));
        URI uri2 = new URI("http://otherdomain.com/admin");
        auth.addAuthentication((Authentication)new BasicAuthentication(uri1, "AdminRealm", "admin", "password"));
    }

    public void clearResults() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        httpClient.getAuthenticationStore().clearAuthenticationResults();
    }

    public void preemptedResult() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        AuthenticationStore auth = httpClient.getAuthenticationStore();
        URI uri = URI.create("http://domain.com/secure");
        auth.addAuthenticationResult((Authentication.Result)new BasicAuthentication.BasicResult(uri, "username", "password"));
    }

    public void requestPreemptedResult() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        URI uri = URI.create("http://domain.com/secure");
        BasicAuthentication.BasicResult authn = new BasicAuthentication.BasicResult(uri, "username", "password");
        Request request = httpClient.newRequest(uri);
        authn.apply(request);
        request.send();
    }

    public void proxy() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        HttpProxy proxy = new HttpProxy("proxyHost", 8888);
        proxy.getExcludedAddresses().add("localhost:8080");
        ProxyConfiguration proxyConfig = httpClient.getProxyConfiguration();
        proxyConfig.getProxies().add(proxy);
        ContentResponse response = httpClient.GET("http://domain.com/path");
    }

    public void proxyAuthentication() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        AuthenticationStore auth = httpClient.getAuthenticationStore();
        URI proxyURI = new URI("http://proxy.net:8080");
        auth.addAuthentication((Authentication)new BasicAuthentication(proxyURI, "ProxyRealm", "proxyUser", "proxyPass"));
        URI serverURI = new URI("http://domain.com/secure");
        auth.addAuthentication((Authentication)new DigestAuthentication(serverURI, "ServerRealm", "serverUser", "serverPass"));
        ProxyConfiguration proxyConfig = httpClient.getProxyConfiguration();
        HttpProxy proxy = new HttpProxy("proxy.net", 8080);
        proxyConfig.getProxies().add(proxy);
        ContentResponse response = httpClient.newRequest(serverURI).send();
    }

    public void defaultTransport() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
    }

    public void http11Transport() throws Exception {
        HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP();
        transport.setHeaderCacheSize(16384);
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.start();
    }

    public void http2Transport() throws Exception {
        HTTP2Client h2Client = new HTTP2Client();
        h2Client.setInitialSessionRecvWindow(0x4000000);
        HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(h2Client);
        transport.setUseALPN(true);
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.start();
    }

    public void fcgiTransport() throws Exception {
        String scriptRoot = "/var/www/wordpress";
        HttpClientTransportOverFCGI transport = new HttpClientTransportOverFCGI(scriptRoot);
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.start();
    }

    public void dynamicDefault() throws Exception {
        HttpClientTransportDynamic transport = new HttpClientTransportDynamic();
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.start();
    }

    public void dynamicOneProtocol() {
        ClientConnector connector = new ClientConnector();
        HttpClientTransportDynamic http11Transport = new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[]{HttpClientConnectionFactory.HTTP11});
        HTTP2Client http2Client = new HTTP2Client(connector);
        HttpClientTransportDynamic http2Transport = new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[]{new ClientConnectionFactoryOverHTTP2.HTTP2(http2Client)});
    }

    public void dynamicH1H2() throws Exception {
        ClientConnector connector = new ClientConnector();
        ClientConnectionFactory.Info http1 = HttpClientConnectionFactory.HTTP11;
        HTTP2Client http2Client = new HTTP2Client(connector);
        ClientConnectionFactoryOverHTTP2.HTTP2 http2 = new ClientConnectionFactoryOverHTTP2.HTTP2(http2Client);
        HttpClientTransportDynamic transport = new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[]{http1, http2});
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.start();
    }

    public void dynamicClearText() throws Exception {
        ClientConnector connector = new ClientConnector();
        ClientConnectionFactory.Info http1 = HttpClientConnectionFactory.HTTP11;
        HTTP2Client http2Client = new HTTP2Client(connector);
        ClientConnectionFactoryOverHTTP2.HTTP2 http2 = new ClientConnectionFactoryOverHTTP2.HTTP2(http2Client);
        HttpClientTransportDynamic transport = new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[]{http1, http2});
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.start();
        ContentResponse http1Response = client.newRequest("host", 8080).send();
        ContentResponse http2Response = client.newRequest("host", 8080).version(HttpVersion.HTTP_2).send();
        ContentResponse upgradedResponse = client.newRequest("host", 8080).headers(headers -> headers.put(HttpHeader.UPGRADE, "h2c").put(HttpHeader.HTTP2_SETTINGS, "").put(HttpHeader.CONNECTION, "Upgrade, HTTP2-Settings")).send();
    }

    public void getConnectionPool() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        ConnectionPool connectionPool = httpClient.getDestinations().stream().map(HttpDestination.class::cast).filter(destination -> destination.getOrigin().getAddress().getHost().equals("domain.com")).findAny().map(HttpDestination::getConnectionPool).orElse(null);
    }

    public void setConnectionPool() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        int maxConnectionsPerDestination = httpClient.getMaxConnectionsPerDestination();
        int maxRequestsPerConnection = 1;
        HttpClientTransport transport = httpClient.getTransport();
        transport.setConnectionPoolFactory(destination -> new RoundRobinConnectionPool(destination, maxConnectionsPerDestination, (Callback)destination, maxRequestsPerConnection));
    }
}

