/*
 * Decompiled with CFR 0.152.
 */
package embedded.client;

import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class ClientConnectorDocs {
    public void simplest() throws Exception {
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.start();
    }

    public void typical() throws Exception {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.addExcludeProtocols(new String[]{"TLSv1", "TLSv1.1"});
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("client");
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setExecutor((Executor)threadPool);
        clientConnector.start();
    }

    public void advanced() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("client");
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler("scheduler-client", false);
        class CustomClientConnector
        extends ClientConnector {
            CustomClientConnector() {
            }

            protected SelectorManager newSelectorManager() {
                return new ClientConnector.ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors()){

                    protected void endPointOpened(EndPoint endpoint) {
                        System.getLogger("endpoint").log(System.Logger.Level.INFO, "opened %s", endpoint);
                    }

                    protected void endPointClosed(EndPoint endpoint) {
                        System.getLogger("endpoint").log(System.Logger.Level.INFO, "closed %s", endpoint);
                    }
                };
            }
        }
        CustomClientConnector clientConnector = new CustomClientConnector();
        clientConnector.setExecutor((Executor)threadPool);
        clientConnector.setScheduler((Scheduler)scheduler);
        clientConnector.start();
    }

    public void connect() throws Exception {
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.start();
        String host = "serverHost";
        int port = 8080;
        InetSocketAddress address = new InetSocketAddress(host, port);
        ClientConnectionFactory connectionFactory = (endPoint, context) -> {
            System.getLogger("connection").log(System.Logger.Level.INFO, "Creating connection for {0}", endPoint);
            class CustomConnection
            extends AbstractConnection {
                public CustomConnection(EndPoint endPoint, Executor executor) {
                    super(endPoint, executor);
                }

                public void onOpen() {
                    super.onOpen();
                    System.getLogger("connection").log(System.Logger.Level.INFO, "Opened connection {0}", new Object[]{this});
                }

                public void onFillable() {
                }
            }
            return new CustomConnection(endPoint, clientConnector.getExecutor());
        };
        Promise.Completable connectionPromise = new Promise.Completable();
        HashMap<String, Object> context2 = new HashMap<String, Object>();
        context2.put("org.eclipse.jetty.client.connector.clientConnectionFactory", connectionFactory);
        context2.put("org.eclipse.jetty.client.connector.connectionPromise", connectionPromise);
        clientConnector.connect((SocketAddress)address, context2);
        connectionPromise.whenComplete((connection, failure) -> System.getLogger("connection").log(System.Logger.Level.INFO, "Created connection for {0}", connection));
    }

    public void telnet() throws Exception {
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.start();
        String host = "wikipedia.org";
        int port = 80;
        InetSocketAddress address = new InetSocketAddress(host, port);
        ClientConnectionFactory connectionFactory = (endPoint, context) -> {
            class TelnetConnection
            extends AbstractConnection {
                private final ByteArrayOutputStream bytes;
                private Consumer<String> consumer;

                public TelnetConnection(EndPoint endPoint, Executor executor) {
                    super(endPoint, executor);
                    this.bytes = new ByteArrayOutputStream();
                }

                public void onOpen() {
                    super.onOpen();
                    this.fillInterested();
                }

                public void onFillable() {
                    try {
                        int filled;
                        ByteBuffer buffer = BufferUtil.allocate((int)1024);
                        while ((filled = this.getEndPoint().fill(buffer)) > 0) {
                            while (buffer.hasRemaining()) {
                                byte read = buffer.get();
                                if (read == 10) {
                                    this.consumer.accept(this.bytes.toString(StandardCharsets.UTF_8));
                                    this.bytes.reset();
                                    continue;
                                }
                                this.bytes.write(read);
                            }
                        }
                        if (filled == 0) {
                            this.fillInterested();
                            return;
                        }
                        this.getEndPoint().close();
                        return;
                    }
                    catch (Exception x) {
                        this.getEndPoint().close((Throwable)x);
                        return;
                    }
                }

                public void onLine(Consumer<String> consumer) {
                    this.consumer = consumer;
                }

                public void writeLine(String line, Callback callback) {
                    line = (String)line + "\r\n";
                    this.getEndPoint().write(callback, new ByteBuffer[]{ByteBuffer.wrap(((String)line).getBytes(StandardCharsets.UTF_8))});
                }
            }
            return new TelnetConnection(endPoint, clientConnector.getExecutor());
        };
        Promise.Completable connectionPromise = new Promise.Completable();
        HashMap<String, Object> context2 = new HashMap<String, Object>();
        context2.put("org.eclipse.jetty.client.connector.clientConnectionFactory", connectionFactory);
        context2.put("org.eclipse.jetty.client.connector.connectionPromise", connectionPromise);
        clientConnector.connect((SocketAddress)address, context2);
        connectionPromise.whenComplete((connection, failure) -> {
            if (failure == null) {
                connection.onLine(line -> System.getLogger("app").log(System.Logger.Level.INFO, "line: {0}", line));
                connection.writeLine("GET / HTTP/1.0\r\n", Callback.NOOP);
            } else {
                failure.printStackTrace();
            }
        });
    }

    public void tlsTelnet() throws Exception {
        class TelnetConnection
        extends AbstractConnection {
            private final ByteArrayOutputStream bytes;
            private Consumer<String> consumer;

            public TelnetConnection(EndPoint endPoint, Executor executor) {
                super(endPoint, executor);
                this.bytes = new ByteArrayOutputStream();
            }

            public void onOpen() {
                super.onOpen();
                this.fillInterested();
            }

            public void onFillable() {
                try {
                    int filled;
                    ByteBuffer buffer = BufferUtil.allocate((int)1024);
                    while ((filled = this.getEndPoint().fill(buffer)) > 0) {
                        while (buffer.hasRemaining()) {
                            byte read = buffer.get();
                            if (read == 10) {
                                this.consumer.accept(this.bytes.toString(StandardCharsets.UTF_8));
                                this.bytes.reset();
                                continue;
                            }
                            this.bytes.write(read);
                        }
                    }
                    if (filled == 0) {
                        this.fillInterested();
                        return;
                    }
                    this.getEndPoint().close();
                    return;
                }
                catch (Exception x) {
                    this.getEndPoint().close((Throwable)x);
                    return;
                }
            }

            public void onLine(Consumer<String> consumer) {
                this.consumer = consumer;
            }

            public void writeLine(String line, Callback callback) {
                line = (String)line + "\r\n";
                this.getEndPoint().write(callback, new ByteBuffer[]{ByteBuffer.wrap(((String)line).getBytes(StandardCharsets.UTF_8))});
            }
        }
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.start();
        String host = "wikipedia.org";
        int port = 443;
        InetSocketAddress address = new InetSocketAddress(host, port);
        ClientConnectionFactory connectionFactory = (endPoint, context) -> new TelnetConnection(endPoint, clientConnector.getExecutor());
        connectionFactory = new SslClientConnectionFactory((SslContextFactory)clientConnector.getSslContextFactory(), clientConnector.getByteBufferPool(), clientConnector.getExecutor(), connectionFactory);
        Promise.Completable connectionPromise = new Promise.Completable();
        HashMap<String, Object> context2 = new HashMap<String, Object>();
        context2.put("org.eclipse.jetty.client.connector.clientConnectionFactory", connectionFactory);
        context2.put("org.eclipse.jetty.client.connector.connectionPromise", connectionPromise);
        clientConnector.connect((SocketAddress)address, context2);
        connectionPromise.whenComplete((sslConnection, failure) -> {
            if (failure == null) {
                TelnetConnection connection = (TelnetConnection)sslConnection.getDecryptedEndPoint().getConnection();
                connection.onLine(line -> System.getLogger("app").log(System.Logger.Level.INFO, "line: {0}", line));
                connection.writeLine("GET / HTTP/1.0\r\n", Callback.NOOP);
            } else {
                failure.printStackTrace();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        new ClientConnectorDocs().tlsTelnet();
    }
}

