/*
 * Decompiled with CFR 0.152.
 */
package embedded;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JMXDocs {
    public void server() {
        Server server = new Server();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbeanContainer);
    }

    public void client() {
        HttpClient httpClient = new HttpClient();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        httpClient.addBean((Object)mbeanContainer);
    }

    public void remote() throws Exception {
        Server server = new Server();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbeanContainer);
        JMXServiceURL jmxURL = new JMXServiceURL("rmi", null, 1999, "/jndi/rmi:///jmxrmi");
        ConnectorServer jmxServer = new ConnectorServer(jmxURL, "org.eclipse.jetty.jmx:name=rmiconnectorserver");
        server.addBean((Object)jmxServer);
        server.start();
    }

    public static void main(String[] args) throws Exception {
        new JMXDocs().remote();
    }

    public void remoteAuthorization() throws Exception {
        Server server = new Server();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbeanContainer);
        JMXServiceURL jmxURL = new JMXServiceURL("rmi", null, 1099, "/jndi/rmi:///jmxrmi");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("com.sun.management.jmxremote.access.file", "/path/to/users.access");
        env.put("com.sun.management.jmxremote.password.file", "/path/to/users.password");
        ConnectorServer jmxServer = new ConnectorServer(jmxURL, env, "org.eclipse.jetty.jmx:name=rmiconnectorserver");
        server.addBean((Object)jmxServer);
        server.start();
    }

    public void tlsRemote() throws Exception {
        Server server = new Server();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbeanContainer);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        JMXServiceURL jmxURL = new JMXServiceURL("rmi", null, 1099, "/jndi/rmi:///jmxrmi");
        ConnectorServer jmxServer = new ConnectorServer(jmxURL, null, "org.eclipse.jetty.jmx:name=rmiconnectorserver", sslContextFactory);
        server.addBean((Object)jmxServer);
        server.start();
    }

    public void tlsJMXConnector() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "/path/to/trustStore");
        System.setProperty("javax.net.ssl.trustStorePassword", "secret");
        JMXServiceURL jmxURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://domain.com:1100/jmxrmi");
        HashMap<String, SslRMIClientSocketFactory> clientEnv = new HashMap<String, SslRMIClientSocketFactory>();
        clientEnv.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
        try (JMXConnector client = JMXConnectorFactory.connect(jmxURL, clientEnv);){
            Set<ObjectName> set = client.getMBeanServerConnection().queryNames(null, null);
        }
    }

    public void jmxAnnotation() throws Exception {
    }

    public void jmxCustomMBean() {
    }

    public void jmxCustomMBeanOverride() {
    }
}

