/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jetty.deploy.ContextHandlerFactory;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardContextHandlerFactory
implements ContextHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StandardContextHandlerFactory.class);

    private static Map<String, String> asProperties(Attributes attributes) {
        HashMap<String, String> props = new HashMap<String, String>();
        attributes.getAttributeNameSet().forEach(name -> {
            Object value = attributes.getAttribute(name);
            props.put((String)name, Objects.toString(value));
        });
        return props;
    }

    private static String asPropertyValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Enum) {
            Enum en = (Enum)obj;
            return en.name();
        }
        if (obj instanceof Environment) {
            Environment env = (Environment)obj;
            return env.getName();
        }
        return Objects.toString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextHandler newContextHandler(Server server, Environment environment, Path mainPath, Set<Path> otherPaths, Attributes deployAttributes) throws Exception {
        if (!Files.exists(mainPath = Objects.requireNonNull(mainPath).toRealPath(new LinkOption[0]), new LinkOption[0])) {
            throw new IllegalStateException("Main path does not exist " + String.valueOf(mainPath));
        }
        deployAttributes.setAttribute("jetty.deploy.paths.main", (Object)mainPath);
        deployAttributes.setAttribute("jetty.deploy.paths.other", otherPaths);
        if (environment == null) {
            String error = String.format("Environment not declared for app [%s].  The available environments are: %s", mainPath, Environment.getAll().stream().map(Environment::getName).collect(Collectors.joining(", ", "[", "]")));
            throw new IllegalStateException(error);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("createContextHandler {} in {}", (Object)mainPath, (Object)environment.getName());
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(environment.getClassLoader());
            Object context = this.newContextInstance(server, environment, mainPath, deployAttributes, mainPath);
            if (context == null) {
                throw new IllegalStateException("unable to create ContextHandler for " + String.valueOf(mainPath));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Context {} created from app {}", (Object)context.getClass().getName(), (Object)mainPath);
            }
            if (this.applyEnvironmentXml(server, context, environment, deployAttributes) && FileID.isXml((Path)mainPath)) {
                context = this.applyXml(server, context, mainPath, environment, deployAttributes);
            }
            ContextHandler contextHandler = this.getContextHandler(context);
            deployAttributes.getAttributeNameSet().forEach(k -> contextHandler.setAttribute(k, deployAttributes.getAttribute(k)));
            ContextHandler contextHandler2 = contextHandler;
            return contextHandler2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object applyXml(Server server, Object context, final Path xml, Environment environment, final Attributes attributes) throws Exception {
        if (!FileID.isXml((Path)xml)) {
            return null;
        }
        try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
            ClassLoader oldClassLoader;
            XmlConfiguration xmlConfiguration;
            block12: {
                xmlConfiguration = new XmlConfiguration(this, resourceFactory.newResource(xml), null, StandardContextHandlerFactory.asProperties(attributes)){
                    final /* synthetic */ StandardContextHandlerFactory this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0, arg1, arg2);
                    }

                    public void initializeDefaults(Object context) {
                        super.initializeDefaults(context);
                        ContextHandler contextHandler = this.this$0.getContextHandler(context);
                        if (contextHandler == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Not a ContextHandler: Not initializing Context {}", context);
                            }
                        } else {
                            this.this$0.initializeContextPath(contextHandler, xml, attributes);
                            this.this$0.initializeContextHandler(contextHandler, xml, attributes);
                        }
                    }
                };
                xmlConfiguration.getIdMap().put("Environment", environment.getName());
                xmlConfiguration.setJettyStandardIdsAndProperties((Object)server, xml);
                attributes.getAttributeNameSet().stream().filter(k -> !k.startsWith("jetty.home") && !k.startsWith("jetty.base") && !k.startsWith("jetty.webapps")).forEach(k -> {
                    Object v = attributes.getAttribute(k);
                    if (v == null) {
                        xmlConfiguration.getProperties().remove(k);
                    } else {
                        xmlConfiguration.getProperties().put(k, StandardContextHandlerFactory.asPropertyValue(v));
                    }
                });
                ClassLoader xmlClassLoader = this.getClassLoader(context, environment);
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(xmlClassLoader);
                try {
                    if (context != null) break block12;
                    Object object = xmlConfiguration.configure();
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    return object;
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    throw throwable;
                }
            }
            Object object = xmlConfiguration.configure(context);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            return object;
        }
    }

    protected void initializeContextHandler(ContextHandler contextHandler, Path path, Attributes attributes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializeContextHandler {}", (Object)contextHandler);
        }
        assert (contextHandler != null);
        if (contextHandler.getBaseResource() == null) {
            ResourceFactory resourceFactory = ResourceFactory.of((Container)contextHandler);
            Resource resource = resourceFactory.newResource(path);
            if (Resources.isDirectory((Resource)resource)) {
                contextHandler.setBaseResource(resource);
            } else if (attributes.getAttribute("jetty.deploy.baseResource") == null) {
                attributes.setAttribute("jetty.deploy.baseResource", (Object)resource);
            }
        }
        attributes.getAttributeNameSet().forEach(key -> {
            Object value = attributes.getAttribute(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting attribute [{}] to [{}] in context {}", new Object[]{key, value, contextHandler});
            }
            contextHandler.setAttribute(key, value);
        });
        String contextPath = (String)attributes.getAttribute("jetty.deploy.contextPath");
        if (StringUtil.isNotBlank((String)contextPath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Context {} initialized with contextPath: {}", (Object)contextHandler, (Object)contextPath);
            }
            contextHandler.setContextPath(contextPath);
        }
    }

    protected void initializeContextPath(ContextHandler contextHandler, Path path, Attributes attributes) {
        if (contextHandler == null) {
            return;
        }
        String basename = FileID.getBasename((Path)path);
        Object contextPath = basename;
        if (((String)contextPath).equalsIgnoreCase("root")) {
            contextPath = "/";
        } else if (StringUtil.asciiStartsWithIgnoreCase((String)contextPath, (String)"root-")) {
            int dash = ((String)contextPath).indexOf(45);
            String virtual = ((String)contextPath).substring(dash + 1);
            contextHandler.setVirtualHosts(Arrays.asList(virtual.split(",")));
            contextPath = "/";
        }
        if (((String)contextPath).charAt(0) != '/') {
            contextPath = "/" + (String)contextPath;
        }
        contextHandler.setDisplayName(basename);
        attributes.setAttribute("jetty.deploy.defaultContextPath", contextPath);
    }

    private boolean applyEnvironmentXml(Server server, Object context, Environment environment, Attributes attributes) throws Exception {
        List sortedEnvXmlPaths = (List)attributes.getAttribute("jetty.deploy.paths.environmentXmls");
        if (sortedEnvXmlPaths == null || sortedEnvXmlPaths.isEmpty()) {
            return false;
        }
        for (Path envXmlPath : sortedEnvXmlPaths) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Applying environment specific context file {}", (Object)envXmlPath);
            }
            context = this.applyXml(server, context, envXmlPath, environment, attributes);
        }
        return true;
    }

    private ClassLoader getClassLoader(Object context, Environment environment) {
        ClassLoader classLoader;
        ContextHandler contextHandler = this.getContextHandler(context);
        if (context != null && (classLoader = contextHandler.getClassLoader()) != null) {
            return classLoader;
        }
        return environment.getClassLoader();
    }

    private ContextHandler getContextHandler(Object context) {
        if (context == null) {
            return null;
        }
        if (context instanceof ContextHandler) {
            ContextHandler handler = (ContextHandler)context;
            return handler;
        }
        if (Supplier.class.isAssignableFrom(context.getClass())) {
            Supplier provider = (Supplier)context;
            return (ContextHandler)provider.get();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not a context {}", context);
        }
        return null;
    }

    private void initializeDeployable(Object context, Attributes attributes) {
        Path mainPath;
        if (attributes.getAttribute("jetty.deploy.war") == null && FileID.isWebArchive((Path)(mainPath = (Path)attributes.getAttribute("jetty.deploy.paths.main")))) {
            attributes.setAttribute("jetty.deploy.war", (Object)mainPath.toString());
        }
        if (context instanceof Deployable) {
            Deployable deployable = (Deployable)context;
            deployable.initializeDefaults(attributes);
        }
    }

    private Object newContextInstance(Server server, Environment environment, Path app, Attributes attributes, Path path) throws Exception {
        ContextHandler contextHandler;
        Object context;
        if (LOG.isDebugEnabled()) {
            LOG.debug("newContextInstance({}, {}, {}, {})", new Object[]{server, environment, app, path});
        }
        if ((context = this.newInstance((String)attributes.getAttribute("jetty.deploy.contextHandlerClass"))) != null) {
            contextHandler = this.getContextHandler(context);
            if (contextHandler == null) {
                throw new IllegalStateException("Unknown context type of " + String.valueOf(context));
            }
            this.initializeContextPath(contextHandler, path, attributes);
            this.initializeContextHandler(contextHandler, path, attributes);
            this.initializeDeployable(context, attributes);
        }
        if (FileID.isXml((Path)path)) {
            boolean createdContext = context == null;
            ContextHandler contextHandler2 = this.getContextHandler(context = this.applyXml(server, context, path, environment, attributes));
            if (contextHandler2 == null) {
                throw new IllegalStateException("Unknown context type of " + String.valueOf(context));
            }
            if (createdContext) {
                this.initializeContextPath(contextHandler2, path, attributes);
                this.initializeContextHandler(contextHandler2, path, attributes);
                this.initializeDeployable(context, attributes);
            }
            return context;
        }
        if (context != null) {
            return context;
        }
        context = this.newInstance((String)environment.getAttribute("jetty.deploy.default.contextHandlerClass"));
        if (context != null) {
            contextHandler = this.getContextHandler(context);
            if (contextHandler == null) {
                throw new IllegalStateException("Unknown context type of " + String.valueOf(context));
            }
            this.initializeContextPath(contextHandler, path, attributes);
            this.initializeContextHandler(contextHandler, path, attributes);
            this.initializeDeployable(context, attributes);
            return context;
        }
        return null;
    }

    private Object newInstance(String className) throws Exception {
        Class clazz;
        if (StringUtil.isBlank((String)className)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to load class {}", (Object)className);
        }
        if ((clazz = Loader.loadClass((String)className)) == null) {
            return null;
        }
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

