//
// ========================================================================
// Copyright (c) 1995 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
// which is available at https://www.apache.org/licenses/LICENSE-2.0.
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package org.eclipse.jetty.client.transport;

import org.eclipse.jetty.util.TypeUtil;

public class SendFailure
{
    public final Throwable failure;
    public final boolean retry;

    public SendFailure(Throwable failure, boolean retry)
    {
        this.failure = failure;
        this.retry = retry;
    }

    @Override
    public String toString()
    {
        return String.format("%s@%x[failure=%s,retry=%b]",
            TypeUtil.toShortName(getClass()),
            hashCode(),
            failure,
            retry);
    }
}
