/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.server.Server;

public class Monitor
extends Thread {
    private String stopKey;
    private Server[] servers;
    private ServerSocket serverSocket;

    public Monitor(int port, String key, Server[] servers) throws Exception {
        if (port <= 0) {
            throw new IllegalStateException("Bad stop port");
        }
        if (key == null) {
            throw new IllegalStateException("Bad stop key");
        }
        if (servers == null) {
            throw new IllegalStateException("No servers");
        }
        this.stopKey = key;
        this.servers = servers;
        this.setName("JettyStopTaskMonitor");
        this.setDaemon(true);
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", port);
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        try {
            this.serverSocket.bind(address, 1);
            TaskLog.log("Jetty monitoring port 127.0.0.1:" + port);
        }
        catch (IOException x) {
            TaskLog.log("Error binding to stop port 127.0.0.1:" + port);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.serverSocket != null) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                socket.setSoLinger(false, 0);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                System.err.println("Monitor: " + key);
                if (!this.stopKey.equals(key)) continue;
                String cmd = lin.readLine();
                if ("stop".equals(cmd)) {
                    this.close(this.serverSocket);
                    this.serverSocket = null;
                    for (Server s : this.servers) {
                        try {
                            TaskLog.log("Stopping server: " + s);
                            s.stop();
                            TaskLog.log("Stopped server: " + s);
                        }
                        catch (Exception e) {
                            TaskLog.log(e.getMessage());
                        }
                    }
                    socket.getOutputStream().write("Stopped\r\n".getBytes());
                    continue;
                }
                TaskLog.log("Unsupported monitor operation: " + cmd);
            }
            catch (Exception e) {
                TaskLog.log(e.getMessage());
            }
            finally {
                this.close(socket);
                socket = null;
                this.close(this.serverSocket);
            }
        }
    }

    private void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            TaskLog.log(e.getMessage());
        }
    }
}

