/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServletAnnotation
extends DiscoveredAnnotation {
    public WebServletAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            Log.warn((String)(this._className + " cannot be loaded"));
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            Log.warn((String)(clazz.getName() + " is not assignable from javax.servlet.http.HttpServlet"));
            return;
        }
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            Log.warn((String)(clazz.getName() + " defines both @WebServlet.value and @WebServlet.urlPatterns"));
            return;
        }
        String[] urlPatterns = annotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = annotation.urlPatterns();
        }
        if (urlPatterns.length == 0) {
            Log.warn((String)(clazz.getName() + " defines neither @WebServlet.value nor @WebServlet.urlPatterns"));
            return;
        }
        ArrayList<String> urlPatternList = new ArrayList<String>();
        for (String p : urlPatterns) {
            urlPatternList.add(Util.normalizePattern(p));
        }
        String servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        MetaData metaData = (MetaData)this._context.getAttribute("org.eclipse.jetty.metaData");
        ServletHolder[] holders = this._context.getServletHandler().getServlets();
        boolean isNew = true;
        ServletHolder holder = null;
        if (holders != null) {
            for (ServletHolder servletHolder : holders) {
                if (!servletHolder.getClassName().equals(clazz.getName()) || !servletHolder.getName().equals(servletName)) continue;
                holder = servletHolder;
                isNew = false;
                break;
            }
        }
        if (isNew) {
            holder = this._context.getServletHandler().newServletHolder(Holder.Source.ANNOTATION);
            holder.setHeldClass(clazz);
            metaData.setOrigin(servletName + ".servlet.servlet-class");
            holder.setName(servletName);
            holder.setDisplayName(annotation.displayName());
            metaData.setOrigin(servletName + ".servlet.display-name");
            holder.setInitOrder(annotation.loadOnStartup());
            metaData.setOrigin(servletName + ".servlet.load-on-startup");
            holder.setAsyncSupported(annotation.asyncSupported());
            metaData.setOrigin(servletName + ".servlet.async-supported");
            for (ServletHolder servletHolder : annotation.initParams()) {
                holder.setInitParameter(servletHolder.name(), servletHolder.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + servletHolder.name());
            }
            this._context.getServletHandler().addServlet(holder);
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(holder.getName());
            mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
            this._context.getServletHandler().addServletMapping(mapping);
            metaData.setOrigin(servletName + ".servlet.mappings");
        } else {
            for (ServletHolder servletHolder : annotation.initParams()) {
                if (metaData.getOrigin(servletName + ".servlet.init-param" + servletHolder.name()) != MetaData.Origin.NotSet) continue;
                holder.setInitParameter(servletHolder.name(), servletHolder.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + servletHolder.name());
            }
            ServletMapping[] mappings = this._context.getServletHandler().getServletMappings();
            if (mappings == null && metaData.getOriginDescriptor(servletName + ".servlet.mappings") != null) {
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(servletName);
                mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
                this._context.getServletHandler().addServletMapping(mapping);
            }
        }
    }
}

