/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.annotation.RunAs;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class RunAsAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _wac;

    public RunAsAnnotationHandler(WebAppContext wac) {
        super(false);
        this._wac = wac;
    }

    @Override
    public void doHandle(Class clazz) {
        RunAsCollection runAsCollection = (RunAsCollection)this._wac.getAttribute("org.eclipse.jetty.runAsCollection");
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        javax.annotation.security.RunAs runAs = clazz.getAnnotation(javax.annotation.security.RunAs.class);
        if (runAs != null) {
            String role = runAs.value();
            if (role != null) {
                RunAs ra = new RunAs();
                ra.setTargetClassName(clazz.getCanonicalName());
                ra.setRoleName(role);
                runAsCollection.add(ra);
            } else {
                Log.warn((String)("Bad value for @RunAs annotation on class " + clazz.getName()));
            }
        }
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@RunAs annotation not applicable for fields: " + className + "." + fieldName));
    }

    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@RunAs annotation ignored on method: " + className + "." + methodName + " " + signature));
    }
}

